% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{calcSummaryOutputValues}
\alias{calcSummaryOutputValues}
\title{Internal/private method. Compute bounds and summary statistics according to Jiang et al. 2019}
\usage{
calcSummaryOutputValues(x, t, n, trueBetaB = NULL,
  useXRangeOffset = TRUE, returnAdditionalStats = FALSE)
}
\arguments{
\item{x}{Numeric (double-precision) vector. Contains the proportion of variable X in each precinct (or analagous geographic unit)}

\item{t}{Numeric (double-precision) vector. Contains the proportion of variable T in each precinct (or analagous geographic unit)}

\item{n}{Numeric (double-precision) vector. Contains the number of elements (people/households/etc.) in each precinct (or analagous geographic unit)}

\item{trueBetaB}{Numeric (double-precision) vector. Contains the true conditional values (beta_i) in each precinct (or analagous geographic unit).
Optional. Default NULL.}

\item{useXRangeOffset}{boolean If True, an offset of 0.00001 is applied to l and u to avoid division by 0 in subsequent calculations. Default TRUE}

\item{returnAdditionalStats}{boolean If True, additional summary statistics are generated. Default FALSE.}
}
\value{
List object with the bounds and summary statistics
}
\description{
\code{calcSummaryOutputValues()} is an internal/private helper method for calculating the bounds. Called by generateBounds().
}
\examples{
\dontrun{
outputList <- calcSummaryOutputValues(x, t, n, NULL, TRUE, FALSE)
}

}
