% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/docs_bulk.r
\name{docs_bulk}
\alias{docs_bulk}
\title{Use the bulk API to create, index, update, or delete documents.}
\usage{
docs_bulk(x, index = NULL, type = NULL, chunk_size = 1000, raw = FALSE,
  ...)
}
\arguments{
\item{x}{A data.frame or path to a file to load in the bulk API}

\item{index}{(character) The index name to use. Required for data.frame input, but
optional for file inputs.}

\item{type}{(character) The type name to use. If left as NULL, will be same name as index.}

\item{chunk_size}{(integer) Size of each chunk. If your data.frame is smaller
thank \code{chunk_size}, this parameter is essentially ignored. We write in chunks because
at some point, depending on size of each document, and Elasticsearch setup, writing a very
large number of documents in one go becomes slow, so chunking can help. This parameter
is ignored if you pass a file name. Default: 1000}

\item{raw}{(logical) Get raw JSON back or not.}

\item{...}{Pass on curl options to \code{\link[httr]{POST}}}
}
\description{
Use the bulk API to create, index, update, or delete documents.
}
\details{
More on the Bulk API:
\url{http://www.elasticsearch.org/guide/en/elasticsearch/guide/current/bulk.html}.

This function dispatches on data.frame or character input. Character input has
to be a file name or the function stops with an error message.

If you pass a data.frame to this function, we by default to an index operation,
that is, create the record in the index and type given by those parameters to the
function. Down the road perhaps we will try to support other operations on the
bulk API. if you pass a file, of course in that file, you can specify any
operations you want.

Row names are dropped from data.frame, and top level names for a list are dropped
as well.

A progress bar gives the progress for data.frames and lists
}
\examples{
\dontrun{
plosdat <- system.file("examples", "plos_data.json", package = "elastic")
docs_bulk(plosdat)
aliases_get()
index_delete(index='plos')
aliases_get()

# Curl options
library("httr")
plosdat <- system.file("examples", "plos_data.json", package = "elastic")
docs_bulk(plosdat, config=verbose())

# From a data.frame
docs_bulk(mtcars, index = "hello", type = "world")
docs_bulk(iris, "iris", "flowers")
## type can be missing, but index can not
docs_bulk(iris, "flowers")
## big data.frame, 53K rows, load ggplot2 package first
res <- docs_bulk(diamonds, "diam")
Search("diam")$hits$total

# From a list
docs_bulk(apply(iris, 1, as.list), index="iris", type="flowers")
docs_bulk(apply(USArrests, 1, as.list), index="arrests")
dim_list <- apply(diamonds, 1, as.list)
out <- docs_bulk(dim_list, index="diamfromlist")
}
}

