% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/field_caps.R
\name{field_caps}
\alias{field_caps}
\title{Field capabilities}
\usage{
field_caps(fields = NULL, index = NULL, body = list(), raw = FALSE,
  asdf = FALSE, ...)
}
\arguments{
\item{fields}{A list of fields to compute stats for. optional}

\item{index}{Index name, one or more}

\item{body}{Query, either a list or json}

\item{raw}{(logical) Get raw JSON back or not}

\item{asdf}{(logical) If \code{TRUE}, use \code{\link[jsonlite:fromJSON]{jsonlite::fromJSON()}}
to parse JSON directly to a data.frame if possible. If \code{FALSE}
(default), list output is given.}

\item{...}{Curl args passed on to \code{\link[httr:POST]{httr::POST()}}}
}
\description{
The field capabilities API allows to retrieve the capabilities of fields
among multiple indices.
}
\examples{
\dontrun{
connect()

field_caps(body = '{ "fields": ["speaker"] }', index = "shakespeare")
}
}
\references{
\url{https://www.elastic.co/guide/en/elasticsearch/reference/current/search-field-caps.html}
}
\seealso{
\code{\link[=field_stats]{field_stats()}}
}
