test_that("tokenize works", {
  skip_if_offline()
  res <- tokenize("Test text.")
  expect_true(tibble::is_tibble(res))
  expect_equal(nrow(res), 2)
  expect_equal(ncol(res), 5)
  expect_true("sent" %in% names(res))
  expect_true("form" %in% names(res))
  expect_true("tag" %in% names(res))
  expect_true("start" %in% names(res))
  expect_true("len" %in% names(res))

  res <- tokenize("Test text.", stopwords = FALSE)
  expect_true(tibble::is_tibble(res))
  expect_equal(nrow(res), 3)
  expect_equal(ncol(res), 5)
  expect_true("sent" %in% names(res))
  expect_true("form" %in% names(res))
  expect_true("tag" %in% names(res))
  expect_true("start" %in% names(res))
  expect_true("len" %in% names(res))
})
