% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workhorses.R
\name{workhorses}
\alias{workhorses}
\alias{disj_pci}
\alias{disj_nci}
\alias{ovlp_pci}
\alias{ovlp_nci}
\title{elisr's quadriga}
\usage{
disj_pci(df, mrit_min, use)

disj_nci(df, mrit_min, sclvals, use)

ovlp_pci(msdf, mrit_min, overlap_with, use)

ovlp_nci(msdf, mrit_min, overlap_with, sclvals, use)
}
\arguments{
\item{df}{a data frame object.}

\item{mrit_min}{a numerical constant to specify the marginal corrected item
total correlation. The value must be in the range of 0-1.}

\item{use}{an optional string to specify how missing values will enter the
analysis. See \code{use} in \code{\link[stats]{cor}} for details.}

\item{sclvals}{a numerical vector of length 2 indicating the start- and
endpoint of a scale.}

\item{msdf}{a multiple scaled data frame (built with \code{disjoint()}).}

\item{overlap_with}{a string telling \code{overlap()} the set of items for
the extension. To build up on all variables of a fragment use
\code{fragment}, for the core-only option type \code{core}. The default is
set to "fragment".}
}
\value{
\code{disj_pci()} and \code{disj_nci()} both return a list of data
  frames which result from applying the above-mentioned algorithm.

\code{ovlp_pci()} and \code{ovlp_nci()} often return an
  \emph{extended} a list of data frames.
}
\description{
The four workhorses inside \code{elisr}'s user functions
  \code{disjoint()} and \code{overlap()}.

\code{disj_pci()} is a loop which runs through the following
  steps: (1) Set up a (first) scale. (2) Find the two items with the highest
  positive correlation in the data set. (3) If the absolute value of this
  correlation is greater than the pre-specified lower bound
  (\code{mrit_min}), add up the two items to build the core of the emerging
  scale. (4) As long as the value of the correlation between the sum-score
  and a remaining item in the data frame is greater than \code{mrit_min},
  flavor the scale with the appropriate item. (5) If there are at least two
  leftovers in the data frame that meet the inclusion criterion, start over
  again.

\code{disj_nci()} is almost identical to \code{disj_pci()},
  though step (4) varies slightly from above. To take negative correlations
  into account, \code{disj_nci()} flavors the scale with appropriate item as
  long as the \emph{absolute} value of the correlation between the sum-score
  and a remaining items in the data frame is greater than \code{mrit_min}.

\code{ovlp_pci()} takes a disjointedly built scale fragment and
  tries to extend it with those items in the data set, which are not yet
  built into the fragment (aka., its counterpart). Because \code{ovlp_pci()}
  does this for every disjointedly built scale fragment it is a multiple
  one-dimensional extension of \code{disj_pci()}.

The only difference to \code{ovlp_pci()} is that
  \code{ovlp_nci()} can handle reversed items. The extension algorithm
  remains almost the same; \code{ovlp_nci()} flavors \emph{each} scale
  fragment with appropriate items from its counterpart as long as the
  \emph{absolute} value of the correlation between the sum-score and a
  remaining item is greater than \code{mrit_min}. Thus, it is a multiple
  one-dimensional extension of \code{disj_nci()}:
}
\details{
All functions are internal functions.

The \code{use} argument specifies how to set up a correlation matrix in the
presence of missing values. In a typical scaling process this happens at
least twice. First, when determining the core items (the two items in the
correlation matrix with the highest linear relationship). Second, when an
item is proposed for an emerging scale.

Note that all functions use \code{\link[stats]{cor}}'s default method
\code{pearson}.
}
\references{
Müller-Schneider, T. (2001). Multiple Skalierung nach dem
  Kristallisationsprinzip / Multiple Scaling According to the Principle of
  Crystallization. Zeitschrift für Soziologie, 30(4), 305-315.
  https://doi.org/10.1515/zfsoz-2001-0404
}
