% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biomarkers.R
\name{get_biomarkers_per_type}
\alias{get_biomarkers_per_type}
\title{Get biomarkers from average data differences matrix (per type)}
\usage{
get_biomarkers_per_type(diff.mat, threshold, type)
}
\arguments{
\item{diff.mat}{a matrix whose rows are vectors of average node data
differences between two groups of models based on some kind of classification
(e.g. number of TP predictions) and whose names are set in the \code{rownames}
attribute of the matrix (usually denoting the different classification
groups, e.g. (1,2) means the models that predicted 1 TP synergy vs the models
that predicted 2 TP synergies, if the classification is done by number of TP
predictions). The columns represent the network's node names.}

\item{threshold}{numeric. A number in the [0,1] interval, above which (or
below its negative value) a biomarker will be registered in the returned result.
Values closer to 1 translate to a more strict threshold and thus less
biomarkers are found.}

\item{type}{character. Accepted values are \emph{positive} or \emph{negative}.}
}
\value{
a character vector that includes the node names that were found
either as \emph{positive} or \emph{negative}.
}
\description{
Use this function to find either positive or negative biomarkers across multiple
performance classification group matchings based on a given threshold between
0 and 1.
}
\details{
The logic behind the biomarker selection is that if there is at least one value
in a column of the \code{diff.mat} matrix that surpasses the threshold given, then the
corresponding node (name of the column) is return as a biomarker. This means
that for a single node, if at least one value that represents an average data
difference (for example, the average activity state difference) between any
of the given classification group comparisons is above the given threshold (or
below the negative symmetric threshold), then a \emph{positive} (\emph{negative})
biomarker is reported.
}
\seealso{
Other biomarker functions: 
\code{\link{get_biomarkers}()}
}
\concept{biomarker functions}
