% Generated by roxygen2 (4.0.2): do not edit by hand
\name{plot.tsd}
\alias{plot.tsd}
\title{Plot results of tsd() that best describe temperature-dependent sex determination}
\usage{
\method{plot}{tsd}(x, ..., se = NULL, l = 0.05, males.freq = TRUE,
  las.x = 1, las.y = 1, lab.PT = "Pivotal temperature",
  lab.TRT = paste0("Transitional range of temperatures l=", l * 100, "\%"),
  col.TRT = "gray", col.TRT.CI = rgb(0.8, 0.8, 0.8, 0.5),
  col.PT.CI = rgb(0.8, 0.8, 0.8, 0.5), show.CI = TRUE, replicate = 1000,
  range.CI = 0.95, limit.low.TRT.minimum = 5, limit.high.TRT.maximum = 90,
  print = TRUE)
}
\arguments{
\item{x}{A result file generated by tsd()}

\item{...}{Parameters for plot()}

\item{se}{Standard error for parameters}

\item{l}{The limit to define TRT (see Girondot, 1999)}

\item{males.freq}{Should the graph uses males frequency [TRUE] or females [FALSE]}

\item{las.x}{las parameter for x axis}

\item{las.y}{las parameter for y axis}

\item{lab.PT}{Label to describe pivotal temperature}

\item{lab.TRT}{Label to describe transitional range of temperature}

\item{col.TRT}{The color of TRT}

\item{col.TRT.CI}{The color of CI of TRT based on range.CI}

\item{col.PT.CI}{The color of CI of PT based on range.CI}

\item{show.CI}{Do the CI for the curve should be shown}

\item{replicate}{Number of replicate to estimate SE of TRT}

\item{range.CI}{The range of confidence interval for estimation, default=0.95}

\item{limit.low.TRT.minimum}{Minimum lower limit for TRT}

\item{limit.high.TRT.maximum}{Maximum higher limit for TRT}

\item{print}{Do the results must be printed at screen? TRUE or FALSE}
}
\value{
A list the pivotal temperature, transitional range of temperatures and their SE
}
\description{
Plot the estimates that best describe temperature-dependent sex determination
}
\details{
plot.tsd plot result of tsd() that best describe temperature-dependent sex determination
}
\examples{
\dontrun{
CC_AtlanticSW <- subset(STSRE_TSD, RMU=="Atlantic, SW" &
                          Species=="Caretta caretta" & Sexed!=0)
par(mar=c(4,4,5,1)+0.1)
tsdL <- with (CC_AtlanticSW, tsd(males=Males, females=Females,
                                 temperatures=Incubation.temperature-Correction.factor,
                                 equation="logistic"))
plot(tsdL)
}
}
\author{
Marc Girondot
}
\references{
Girondot, M. 1999. Statistical description of temperature-dependent sex determination using maximum likelihood. Evolutionary Ecology Research, 1, 479-486.

Godfrey, M.H., Delmas, V., Girondot, M., 2003. Assessment of patterns of temperature-dependent sex determination using maximum likelihood model selection. Ecoscience 10, 265-272.

Hulin, V., Delmas, V., Girondot, M., Godfrey, M.H., Guillon, J.-M., 2009. Temperature-dependent sex determination and global change: are some species at greater risk? Oecologia 160, 493-506.

Girondot M., Submited. On the concept of embryological thermosensitive period for sex determination in reptiles.
}

