% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotR.R
\name{plotR}
\alias{plotR}
\title{Show the fitted growth rate dependent on temperature and its density}
\usage{
plotR(result = NULL, resultmcmc = NULL, parameters = NULL,
  fixed.parameters = NULL, temperatures = NULL, curves = "ML quantiles",
  set.par = 1, ylim = c(0, 5), xlim = c(20, 35), hessian = NULL,
  replicate.CI = 1000, cex.lab = par("cex"), cex.axis = par("cex"),
  scaleY = "auto", lty = 1, ltyCI = 3, lwd = 1, lwdCI = 1,
  col = "black", col.polygon = "grey", polygon = FALSE, probs = 0.95,
  colramp = colorRampPalette(c("white", rgb(red = 0.5, green = 0.5, blue =
  0.5))), bandwidth = c(0.1, 0.01), pch = "", main = "",
  xlab = expression("Temperature in " * degree * "C"), ylab = NULL,
  bty = "n", las = 1, by.temperature = 0.1, show.density = FALSE,
  new = TRUE, show.hist = FALSE, ylimH = NULL, atH = NULL,
  ylabH = "Temperature density", breaks = "Sturges", log.hist = FALSE,
  mar = NULL)
}
\arguments{
\item{result}{A result object or a list of result objects}

\item{resultmcmc}{A result object from GRTN_MHmcmc() function}

\item{parameters}{A set of parameters - Has the priority over result}

\item{fixed.parameters}{A set of fixed parameters}

\item{temperatures}{A set of temperatures - Has the priority over result}

\item{curves}{What curves to show: "MCMC quantiles" or "MCMC mean-SD" based on mcmc or "ML" or "ML quantiles" for maximum-likelihood}

\item{set.par}{1 or 2 to designate with set of parameters to show}

\item{ylim}{Range of values for y-axis}

\item{xlim}{Range of values for x-axis}

\item{hessian}{An hessian matrix}

\item{replicate.CI}{Number of replicates to estimate confidence interval with Hessian if delta method failed}

\item{cex.lab}{cex value for axis}

\item{cex.axis}{cex value for axis}

\item{scaleY}{Scaling factor for y axis or "auto"}

\item{lty}{The type of lines}

\item{ltyCI}{The type of lines}

\item{lwd}{The type of lines}

\item{lwdCI}{The type of lines}

\item{col}{The color of the lines}

\item{col.polygon}{The color of the polygon}

\item{polygon}{If TRUE, confidence interval is shown as a polygon with color}

\item{probs}{Confidence or credibility interval to show}

\item{colramp}{Ramp function accepting an integer as an argument and returning n colors.}

\item{bandwidth}{numeric vector (length 1 or 2) of smoothing bandwidth(s). If missing, a more or less useful default is used. bandwidth is subsequently passed to function bkde2D.}

\item{pch}{Character for outlayers}

\item{main}{Title of the graph}

\item{xlab}{Label for x axis}

\item{ylab}{Label for y axis}

\item{bty}{Box around the pot}

\item{las}{Orientation for labels in y axis}

\item{by.temperature}{Step to built the temperatures}

\item{show.density}{TRUE or FALSE for use with Hessian or MCMC}

\item{new}{Should the graphics be a new one (TRUE) or superimposed to a previous one (FALSE)}

\item{show.hist}{TRUE or FALSE}

\item{ylimH}{Scale of histogram using ylimH=c(min, max)}

\item{atH}{Position of ticks for scale of histogram}

\item{ylabH}{Label for histogram scale}

\item{breaks}{See ?hist}

\item{log.hist}{SHould the y scale for hist is log ?}

\item{mar}{The value of par("mar"). If null, it will use default depending on show.dist. If NA, does not change par("mar").}
}
\value{
The value of scaleY to be used with other plotR function
}
\description{
Show the fitted growth rate dependent on temperature and its density.\cr
The curve "ML quantiles" is based on delta method.\cr
The curve "ML" just shows the fitted model.\cr
The curve "MCMC quantiles" uses the mcmc replicates to build the quantiles.\cr
The curve "MCMC mean-SD" uses the mcmc replicates to build a symetric credibility interval.\cr
The parameter curves is case insensitive.
}
\details{
plotR shows the fitted growth rate dependent on temperature and the density of the mcmc
}
\examples{
\dontrun{
library(embryogrowth)
plotR(result = resultNest_4p_SSM4p, 
             resultmcmc=resultNest_mcmc_4p_SSM4p, 
             curves = "MCMC quantiles")
#################
plotR(resultmcmc=resultNest_mcmc_4p_SSM4p, 
             curves = "MCMC quantiles", show.density=TRUE)
#################
plotR(resultmcmc=resultNest_mcmc_4p_SSM4p, 
             curves = "MCMC quantiles", polygon=TRUE)
#################
plotR(resultmcmc=resultNest_mcmc_6p_SSM6p, ylim=c(0,4), 
      curves = "MCMC quantiles", polygon=TRUE, col.polygon = rgb(0, 1, 0, 1))
plotR(resultmcmc=resultNest_mcmc_4p_SSM4p,
       curves = "MCMC quantiles", polygon=TRUE, col.polygon = rgb(1, 0, 0, 0.5), new=FALSE)
legend("topleft", legend=c("SSM 4 parameters", "SSM 6 parameters"), 
        pch=c(15, 15), col=c(rgb(1, 0, 0, 0.5), rgb(0, 1, 0, 1)))
#################
sy <- plotR(resultmcmc=resultNest_mcmc_4p_SSM4p, 
             curves = "MCMC quantiles", show.density=FALSE)
plotR(resultmcmc=resultNest_mcmc_6p_SSM6p, col="red",
             curves = "MCMC quantiles", show.density=FALSE, 
             new=FALSE, scaleY=sy)
#################
sy <- plotR(result=resultNest_6p_SSM6p, curves="ML", 
             show.hist = TRUE, new = TRUE)
plotR(result=resultNest_4p_SSM4p, curves="ML", scaleY=sy, 
             show.hist = FALSE, new = FALSE, col="red")
#################
plotR(result=resultNest_6p_SSM6p, curves="ML", 
             show.hist = TRUE, ylimH=c(0,1), atH=c(0, 0.1, 0.2))
################
plotR(result = resultNest_4p_SSM4p, 
             resultmcmc=resultNest_mcmc_4p_SSM4p, 
             show.density = TRUE, 
             curves = "MCMC quantiles")
#################
plotR(result=resultNest_4p_SSM4p, 
             ylim=c(0, 4), curves="ML quantiles", scaleY=1E5)
#################             
plotR(result=resultNest_4p_SSM4p, show.hist = TRUE,
             ylim=c(0, 4), curves="ML quantiles", scaleY=1E5)
#################
plotR(resultmcmc=resultNest_mcmc_4p_SSM4p, 
             ylim=c(0, 4), curves = "MCMC quantiles", show.density=TRUE, scaleY=1E5)
}
}
\author{
Marc Girondot
}
