% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resultNest_4p_SSM4p.R
\docType{data}
\encoding{UTF-8}
\name{resultNest_4p_SSM4p}
\alias{resultNest_4p_SSM4p}
\title{Fit using the nest database}
\format{
A list with fitted information about data(nest)
}
\usage{
resultNest_4p_SSM4p
}
\description{
Fit using the nest database
}
\details{
Result of the fit using the nest database
}
\examples{
\dontrun{
library(embryogrowth)
data(nest)
formated <- FormatNests(nest)
# The initial parameters value can be:
# "T12H", "DHA",  "DHH", "Rho25"
# Or
# "T12L", "DT", "DHA",  "DHH", "DHL", "Rho25"
x <- structure(c(118.431040984352, 498.205702157603, 306.056280989839, 
118.189669472381), .Names = c("DHA", "DHH", "T12H", "Rho25"))
# pfixed <- c(K=82.33) or rK=82.33/39.33
pfixed <- c(rK=2.093313)
resultNest_4p_SSM4p <- searchR(parameters=x, fixed.parameters=pfixed, 
	temperatures=formated, derivate=dydt.Gompertz, M0=1.7, 
	test=c(Mean=39.33, SD=1.92))
plotR(result=resultNest_4p_SSM4p, show.hist = TRUE,
             ylim=c(0, 4), curves="ML quantiles")
}
}
\references{
Girondot, M., & Kaska, Y. (2014). A model to predict 
            the thermal reaction norm for the embryo growth rate 
            from field data. Journal of Thermal Biology, 45, 96-102. 
            doi: 10.1016/j.jtherbio.2014.08.005
}
\author{
Marc Girondot \email{marc.girondot@u-psud.fr}
}
\keyword{datasets}
