#' nobs.NestsResult Return number of observations of a fit
#' @title Return number of observations of a fit
#' @author Marc Girondot
#' @return Return number of observations of a fit
#' @param object A result file generated by searchR
#' @param ... Not used
#' @description Return number of observations of a fit.\cr
#' This function is used for bbmle::ICtb().
#' @examples
#' \dontrun{
#' library(embryogrowth)
#' data(resultNest_4p_SSM)
#' logLik(resultNest_4p_SSM)
#' AIC(resultNest_4p_SSM)
#' nobs(resultNest_4p_SSM)
#' }
#' @method nobs NestsResult
#' @export


nobs.NestsResult <- function(object, ...) unname(object$data$IndiceT["NbTS"])

