% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/database.R
\name{create_db_topics_daily}
\alias{create_db_topics_daily}
\title{Create daily topics dataset for the ennet_db}
\usage{
create_db_topics_daily(
  repo = "katilingban/ennet_db",
  branch = "main",
  .date = Sys.Date() - 1,
  fn = NULL
)
}
\arguments{
\item{repo}{A character value of the GitHub user and repository name
combination identifying the GitHub location for ennet_db. Default is
\code{katilingban/ennet_db}.}

\item{branch}{A character value for the branch name from which to retrieve
data. Default is \code{main}.}

\item{.date}{A character value or vector of date/dates for which to create
a topics dataset for the ennet_db}

\item{fn}{A character value or vector of filenames for hourly topics dataset
found in ennet_db}
}
\value{
A tibble of daily topics dataset created from data in the
ennet_db
}
\description{
Create daily topics dataset for the ennet_db
}
\examples{
##
fn <- c("ennet_topics_2021-01-17_00:54:48.csv")

create_db_topics_daily(.date = "2021-01-17", fn = fn)

}
\author{
Ernest Guevarra
}
