% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.enpls.R
\name{cv.enpls}
\alias{cv.enpls}
\title{Cross Validation for Ensemble Partial Least Squares Regression}
\usage{
cv.enpls(x, y, nfolds = 5L, verbose = TRUE, ...)
}
\arguments{
\item{x}{predictor matrix}

\item{y}{response vector}

\item{nfolds}{number of folds - default is \code{5}.}

\item{verbose}{shall we print the cross validation process}

\item{...}{other arguments that can be passed to \code{\link{enpls.fit}}}
}
\value{
A list containing:
\itemize{
\item \code{ypred} - a matrix containing two columns: real y and predicted y
\item \code{residual} - cross validation result (y.pred - y.real)
\item \code{RMSE} - RMSE
\item \code{MAE} - MAE
\item \code{Rsquare} - Rsquare
}
}
\description{
K-fold cross validation for ensemble partial least squares regression.
}
\note{
To maximize the probablity that each observation can
be selected in the test set (thus the prediction uncertainty
can be measured), please try setting a large \code{MCtimes}.
}
\examples{
data("alkanes")
x = alkanes$x
y = alkanes$y

set.seed(42)
cvfit = cv.enpls(x, y, MCtimes = 10)
print(cvfit)
plot(cvfit)
}
\author{
Nan Xiao <\url{http://nanx.me}>
}
\seealso{
See \code{\link{enpls.fit}} for ensemble
partial least squares regression.
}

