% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ensembles_Elastic_Net_R.R
\name{cv.ensembleEN}
\alias{cv.ensembleEN}
\title{Ensembles of elastic net algorithm with a sparsity and diversity penalty.}
\usage{
cv.ensembleEN(x, y, num_lambdas_sparsity = 100, num_lambdas_diversity = 100,
  alpha = 1, num_models = 10, tolerance = 1e-08, max_iter = 1e+05,
  num_folds = 10, num_threads = 1)
}
\arguments{
\item{x}{Design matrix.}

\item{y}{Response vector.}

\item{num_lambdas_sparsity}{Length of the grid of sparsity penalties.}

\item{num_lambdas_diversity}{Length of the grid of diversity penalties.}

\item{alpha}{Elastic Net tuning constant: the value must be between 0 and 1. Default is 1 (Lasso).}

\item{num_models}{Number of models to build.}

\item{tolerance}{Tolerance parameter to stop the iterations while cycling over the models.}

\item{max_iter}{Maximum number of iterations before stopping the iterations while cycling over the models.}

\item{num_folds}{Number of folds for cross-validating.}

\item{num_threads}{Number of threads used for parallel computation over the folds.}
}
\value{
An object of class cv.ensembleEN, a list with entries
\item{betas}{Coefficients computed over the path of penalties for sparsity; the penalty for diversity is fixed at the optimal value.}
\item{intercepts}{Intercepts for each of the models along the path of penalties for sparsity.}
\item{index_opt}{Index of the optimal penalty parameter for sparsity.}
\item{lambda_sparsity_opt}{Optimal penalty parameter for sparsity.}
\item{lambda_diversity_opt}{Optimal penalty parameter for diversity.}
\item{lambdas_sparsity}{Grid of sparsity parameters.}
\item{lambdas_diversity}{Grid of diversity parameters.}
\item{cv_mse_opt}{Optimal CV MSE.}
\item{call}{The matched call.}
}
\description{
Computes an ensemble of Elastic Net regularized linear models. The sparsity and diversity penalty
parameters are chosen automatically.
}
\details{
Computes an ensemble of \code{num_models} (\eqn{G}) Elastic Net regularized linear models, defined as the linear models
\eqn{\boldsymbol{\beta}^{1},\dots, \boldsymbol{\beta}^{G}} that minimize
\deqn{\sum\limits_{g=1}^{G}\left( \frac{1}{2n}\Vert \mathbf{y}-\mathbf{X} \boldsymbol{\beta}^{g}\Vert^{2} 
+\lambda_{S}\left( \frac{(1-\alpha)}{2}\Vert \boldsymbol{\beta}^{g}\Vert_{2}^{2}+\alpha \Vert \boldsymbol{
\beta \Vert_1}\right)+\frac{\lambda_{D}}{2}\sum\limits_{h\neq g}\sum_{j=1}^{p}\vert \beta_{j}^{h}\beta_{j}^{g}\vert \right),}
over grids for the penalty parameters \eqn{\lambda_{S}} and \eqn{\lambda_{D}} that are built automatically.
Larger values of \eqn{\lambda_{S}} encourage more sparsity within the models and larger values of \eqn{\lambda_{D}} encourage more diversity
among them. 
If \eqn{\lambda_{D}=0}, then all of the models in the ensemble are equal to the Elastic Net regularized
least squares estimator with penalty parameter \eqn{\lambda_{S}}. Optimal penalty parameters are found by
\code{num_folds} cross-validation, where the prediction of the ensemble is formed by simple averaging.
The predictors and the response are standardized to zero mean and unit variance before any computations are performed.
The final output is in the original scales.
}
\examples{
library(MASS)
set.seed(1)
beta <- c(rep(5, 5), rep(0, 45))
Sigma <- matrix(0.5, 50, 50)
diag(Sigma) <- 1
x <- mvrnorm(50, mu = rep(0, 50), Sigma = Sigma)
y <- x \%*\% beta + rnorm(50)
fit <- cv.ensembleEN(x, y, num_models=2)
coefs <- predict(fit, type="coefficients")

}
\seealso{
\code{\link{predict.cv.ensembleEN}}, \code{\link{coef.cv.ensembleEN}}
}
