% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataTypeCheck.R
\name{dataTypeCheck}
\alias{dataTypeCheck}
\title{Data Type Check}
\usage{
dataTypeCheck(r)
}
\arguments{
\item{r}{raster object}
}
\description{
Determines the best data type to implement when writing the raster to file
}
\details{
Function to determine the most memory efficient data type given whether
or not the raster contains integer or non-integer values,
and the range of those values, based on the definitions described
in \code{\link{dataType}}.
}
\examples{
rasterFiles <- list.files(system.file('extdata', package='envirem'), full.names=TRUE)
r <- raster(rasterFiles[1])
dataTypeCheck(r)
}
\author{
Pascal Title
}
