% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.r
\name{clean_up_matching_environments}
\alias{clean_up_matching_environments}
\title{Clean up the list of environments matching a memory address in an environment map.}
\usage{
clean_up_matching_environments(envmap, indfound)
}
\arguments{
\item{envmap}{data frame with the name-address pairs of environments having at least a column
called "type" that specifies the type of environment, for which "function" is used to indicate
a function execution environment.}

\item{indfound}{array containing the indices in envmap giving the environments to clean up
(typically these are the environments that match a given memory address).}
}
\value{
an array containing the indices in \code{indfound} after cleanup.
}
\description{
Clean up the list of environments matching a memory address in an environment map.
}
\details{
A clean list of matched environments from \code{envmap} should either:
\itemize{
\item contain ONLY ONE function execution environment,
\item contain one ore more user-defined or named environments.
}
If none of the above is the case, all function execution environments are removed from the list
of matching environments, i.e. removed from the \code{indfound} array.
}
\keyword{internal}

