% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UpcomingIPOsAPI.R
\name{get_upcoming_IPOs_data}
\alias{get_upcoming_IPOs_data}
\title{Get upcoming IPOs data}
\usage{
get_upcoming_IPOs_data(api_token, from_date = NULL, to_date = NULL)
}
\arguments{
\item{api_token}{The API token for authentication.}

\item{from_date}{Format: YYYY-MM-DD. The start date for IPOs data, if not provided, today will be used.}

\item{to_date}{Format: YYYY-MM-DD. The end date for IPOs data, if not provided, today + 7 days will be used.}
}
\value{
A list containing the upcoming IPOs data.
}
\description{
This function retrieves upcoming IPOs data from the API.
}
\examples{
api_token <- "demo"
from_date <- "2017-09-10"
to_date <- "2017-09-12"
result <- get_upcoming_IPOs_data(api_token, from_date, to_date)

}
