% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EconomicEventsDataAPI.R
\name{get_economic_events_data}
\alias{get_economic_events_data}
\title{Get economic events data}
\usage{
get_economic_events_data(
  api_token,
  date_from = NULL,
  date_to = NULL,
  country = NULL,
  comparison = NULL,
  offset = NULL,
  limit = NULL
)
}
\arguments{
\item{api_token}{The API token for authentication.}

\item{date_from}{date from with format Y-m-d}

\item{date_to}{date from with format Y-m-d}

\item{country}{The country code is in ISO 3166 format, has 2 symbols}

\item{comparison}{Possible values: mom, qoq, yoy}

\item{offset}{Possible values from 0 to 1000}

\item{limit}{Possible values from 0 to 1000}
}
\value{
A list containing economic data events.
}
\description{
This function retrieves economic events data from the API.
}
\examples{
api_token <- "demo"
date_from <- "2017-09-10"
date_to <- "2017-09-12"
country <- "US"
comparison <- "qoq"
offset <- "0"
limit <- "50"
result <- get_economic_events_data(api_token, date_from, date_to, country,
comparison, offset, limit)

}
