% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_RCP8.5.R
\name{get_RCP8.5}
\alias{get_RCP8.5}
\title{Projected values under IPCC RCP8.5 scenario}
\usage{
get_RCP8.5(date)
}
\arguments{
\item{date}{A specific year or a vector of years.}
}
\value{
No return value, called for side effects.
}
\description{
This function allows obtaining the projected increment in environmental
            temperature according to the IPCC RCP8.5 scenario.
}
\details{
The temperature increment projection of the change in global mean surface
        temperature according to the IPCC RCP8.5 scenario. It is possible to get
        the value for one or various years.
}
\examples{

########################################################################
 #Example 1: Projection of the temperature increase for a given year.
########################################################################

date <- 2050
temp <- get_RCP8.5(date)
temp

########################################################################
  #Example 2: Projection of the temperature increase for a vector of years.
########################################################################

date <- seq(2005,2100,1/12)
temp <- get_RCP8.5(date)
plot(date,temp,type="l")

}
\references{
IPCC. (2014): Climate Change 2014: Synthesis Report. Contribution of Working Groups I,
           II and III to the Fifth Assessment Report of the Intergovernmental Panel on Climate
           Change [Core Writing Team, R.K. Pachauri and L.A. Meyer (eds.)]. IPCC, Geneva,
           Switzerland, 151 pp.
}
