% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forward.R
\name{forward}
\alias{forward}
\title{Applies the forward algorithm to a genotype dataset}
\usage{
forward(X, p_init, p_trans, p_emit, ncores = 1)
}
\arguments{
\item{X}{genotype matrix. Each row corresponds to a separate sample}

\item{p_init}{marginal distributions for the first hidden state}

\item{p_trans}{3D dimensional array for the transition probabilities}

\item{p_emit}{3D dimensional array for the emission probabilities}

\item{ncores}{number of threads (default 1)}
}
\value{
A vector of log probabilities
}
\description{
Applies the \code{forward_sample} function to each row in \code{X}. If
the \code{ncores} > 1, the function calling is performed in a parallel
fashion to reduce the running time. The parallelization backend
is \code{doParallel}.  If the latter package is not installed,
the function switches back to single-core mode.
}
\examples{
p <- 3 # Number of states
K <- 2 # Dimensionality of the latent space

p_init <- rep(1 / K, K)
p_trans <- array(runif((p - 1) * K * K), c(p - 1, K, K))
# Normalizing the transition probabilities
for (j in seq_len(p - 1)) {
  p_trans[j, , ] <- p_trans[j, , ] / (matrix(rowSums(p_trans[j, , ]), ncol = 1) \%*\% rep(1, K))
}

p_emit <- array(stats::runif(p * 3 * K), c(p, 3, K))
# Normalizing the emission probabilities
for (j in seq_len(p)) {
  p_emit[j, , ] <- p_emit[j, , ] / (matrix(rep(1, 3), ncol = 1) \%*\% colSums(p_emit[j, , ]))
}

n <- 2
X <- matrix((runif(n * p, min = 0, max = 1) < 0.4) +
            (runif(n * p, min = 0, max = 1) < 0.4), nrow = 2)

# Computing the joint log-probabilities
log_prob <- forward(X, p_init, p_trans, p_emit)

}
\references{
Rabiner, Lawrence R. 'A tutorial on hidden Markov models
and selected applications in speech recognition.' Proceedings of the
IEEE 77.2 (1989): 257-286.
}
