% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.epicontacts.R
\name{subset.epicontacts}
\alias{subset.epicontacts}
\title{Subset an epicontact object by factors}
\usage{
\method{subset}{epicontacts}(
  x,
  node_attribute = NULL,
  edge_attribute = NULL,
  cluster_id = NULL,
  cs = NULL,
  cs_min = NULL,
  cs_max = NULL,
  ...
)
}
\arguments{
\item{x}{an epi_contact object to be subsetted}

\item{node_attribute}{a named list defining the node attribute name and node
attribute value (as a single value or vector of values).  Dates must be
provided as a vector of date objects, defining the range of dates
included in the subset. If only one date is provided, only node
attributes with that date will be returned.}

\item{edge_attribute}{a named list defining the edge attribute name and edge
attribute value (as a single value or vector of values).  Dates must be
provided as a vector of date objects, defining the range of dates
included in the subset. If only one date is provided, only edge
attributes with that date will be returned.}

\item{cluster_id}{a character vector of case identifiers; the connected
components attached to these cases will be retained in the output object.}

\item{cs}{cluster size to be used for subsetting}

\item{cs_min}{minimum cluster size for subsetting}

\item{cs_max}{maximum cluster size for subsetting}

\item{...}{further arguments passed on to other methods}
}
\description{
This function subsets an \code{\link{epicontacts}} object based on node,
edge and/or cluster attributes. Specifying node attributes will return an
\code{\link{epicontacts}} object containing only individuals with these
given attributes in the linelist. Specifying edge attributes will return
contacts with the attributes provided. Specifying cluster attributes will
return clusters of connected cases, and can be defined by ids (returning
clusters of cases connected to specified cases) or cluster sizes (returning
cluster of a specific, minimum or maximum size).
}
\examples{
if (require(outbreaks)) {
## build data

x <- make_epicontacts(ebola_sim$linelist, ebola_sim$contacts,
                      id = "case_id", to = "case_id",
                      from = "infector", directed = FALSE)

## subset based on node and edge attributes
x_subset <- subset(x, node_attribute = list("gender" = "f"),
                   edge_attribute = list("source" = "funeral"))


## subset a cluster connected to a given id
## (can be a vector of ids as well)
## here picking node with highest out-degree

id <- names(which.max(get_degree(x, "out")))
x_subset <- thin(subset(x, cluster_id = id), 2)
x_subset
plot(x_subset)


## subset based on cluster size range

x_subset <- subset(x, cs_min = 12, cs_max = 15)


## subset based on single cluster size

x_subset <- subset(x, cs = 12)


## subset based on minimum cluster size

x_subset <- subset(x, cs_min = 10)


## subset based on maximum cluster size

x_subset <- subset(x, cs_max = 9)


}
}
\author{
Finlay Campbell (\email{f.campbell15@imperial.ac.uk}), Nistara
    Randhawa (\email{nrandhawa@ucdavis.edu})
}
