% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoints.R
\name{pub_nowcast}
\alias{pub_nowcast}
\title{Delphi's ILI Nearby nowcasts}
\usage{
pub_nowcast(locations, epiweeks = "*", fetch_args = fetch_args_list())
}
\arguments{
\item{locations}{character. Locations to fetch.}

\item{epiweeks}{\code{\link{timeset}}. Epiweeks to fetch. Defaults to all ("*") dates.}

\item{fetch_args}{\code{\link{fetch_args}}. Additional arguments to pass to \code{fetch()}.}
}
\value{
\code{\link[tibble:tibble]{tibble::tibble}}
}
\description{
API docs: \url{https://cmu-delphi.github.io/delphi-epidata/api/nowcast.html}.

Obtains information on outpatient inluenza-like-illness (ILI) from Delphi's
}
\details{
The full list of location inputs can be accessed at
\url{https://github.com/cmu-delphi/delphi-epidata/blob/main/src/acquisition/fluview/fluview_locations.py}.
}
\examples{
\dontrun{
pub_nowcast(locations = "ca", epiweeks = epirange(201201, 201301))
}
}
\keyword{endpoint}
