% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.matrix.epimodel.R
\name{as.matrix.epimodel}
\alias{as.matrix.epimodel}
\alias{as.array.epimodel}
\alias{as.data.frame.epimodel}
\title{Extract posterior samples}
\usage{
\method{as.matrix}{epimodel}(
  x,
  ...,
  pars = NULL,
  regex_pars = NULL,
  par_models = NULL,
  par_types = NULL,
  par_groups = NULL
)

\method{as.array}{epimodel}(
  x,
  ...,
  pars = NULL,
  regex_pars = NULL,
  par_models = NULL,
  par_types = NULL,
  par_groups = NULL
)

\method{as.data.frame}{epimodel}(
  x,
  ...,
  pars = NULL,
  regex_pars = NULL,
  par_models = NULL,
  par_types = NULL,
  par_groups = NULL
)
}
\arguments{
\item{x}{A fitted model object returned by \code{\link{epim}}.
See \code{\link{epimodel-objects}}.}

\item{...}{Not used.}

\item{pars}{Character vector of parameter names to return. Same as \link[rstanarm]{as.matrix.stanreg}}

\item{regex_pars}{Character vector of regular expressions against which to match parameter names.Same as \link[rstanarm]{as.matrix.stanreg}}

\item{par_models}{A character vector that restricts parameters to a subset of
model components. For example, "R" only uses parameters in the transmission model,
"inf" uses parameters in infection model. Strings giving the name of the
response in an observation model (i.e. LHS of the \code{formula} in \code{epiobs})
can also be used. If NULL (the default), all components are used.}

\item{par_types}{A character vector that restricts parameters based on their
type. The vector can include any of "fixed", "autocor", "random", "aux", "latent",
or "seeds". The default is c("fixed", "aux", "seeds"), to avoid printing a
very large number of parameters. If NULL, all types are used.}

\item{par_groups}{A character vector restricting parameters to those
used for a subset of regions in which the epidemic is modeled. Defaults to
NULL in which case all regions are used.}
}
\value{
A \code{matrix}, \code{array} or \code{data.frame} object.
}
\description{
Get parameter samples from a fitted model object of class \code{epimodel}.
}
\details{
\code{as.matrix}, \code{as.array} and \code{as.data.frame} each return
a sample of parameter draws from objects of class \code{epimodel}. The
returned parameters include those in the regression for \eqn{R_{tm}}$, but also
other parameters in the model. These methods closely resemble those
for \code{stanreg} objects in \pkg{rstanarm}. Please see \code{\link[rstanarm]{as.matrix.stanreg}}
for a general explanation of these methods.
}
