% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelSURV.R
\name{ModelSURV}
\alias{ModelSURV}
\alias{epiworld_surv}
\alias{plot.epiworld_surv}
\title{SURV model}
\usage{
ModelSURV(
  name,
  prevalence,
  efficacy_vax,
  latent_period,
  infect_period,
  prob_symptoms,
  prop_vaccinated,
  prop_vax_redux_transm,
  prop_vax_redux_infect,
  surveillance_prob,
  transmission_rate,
  prob_death,
  prob_noreinfect
)

\method{plot}{epiworld_surv}(x, main = get_name(x), ...)
}
\arguments{
\item{name}{String. Name of the virus.}

\item{prevalence}{Initial number of individuals with the virus.}

\item{efficacy_vax}{Double. Efficacy of the vaccine.
(1 - P(acquire the disease)).}

\item{latent_period}{Double. Shape parameter of a 'Gamma(latent_period, 1)'
distribution. This coincides with the expected number of latent days.}

\item{infect_period}{Double. Shape parameter of a 'Gamma(infected_period, 1)'
distribution. This coincides with the expected number of infectious days.}

\item{prob_symptoms}{Double. Probability of generating symptoms.}

\item{prop_vaccinated}{Double. Probability of vaccination. Coincides with
the initial prevalence of vaccinated individuals.}

\item{prop_vax_redux_transm}{Double. Factor by which the vaccine reduces
transmissibility.}

\item{prop_vax_redux_infect}{Double. Factor by which the vaccine reduces
the chances of becoming infected.}

\item{surveillance_prob}{Double. Probability of testing an agent.}

\item{transmission_rate}{Double. Raw transmission probability.}

\item{prob_death}{Double. Raw probability of death for symptomatic
individuals.}

\item{prob_noreinfect}{Double. Probability of no re-infection.}

\item{x}{Object of class SURV.}

\item{main}{Title of the plot.}

\item{...}{Currently ignore.}
}
\value{
\itemize{
\item The \code{ModelSURV}function returns a model of class \link{epiworld_model}.
}

The \code{plot} function returns a plot of the SURV model of class
\link{epiworld_model}.
}
\description{
SURV model
}
\examples{
model_surv <- ModelSURV(
  name                  = "COVID-19",
  prevalence            = 20,
  efficacy_vax          = 0.6,
  latent_period         = 4,
  infect_period         = 5,
  prob_symptoms         = 0.5,
  prop_vaccinated       = 0.7,
  prop_vax_redux_transm = 0.8,
  prop_vax_redux_infect = 0.95,
  surveillance_prob     = 0.1,
  transmission_rate     = 0.2,
  prob_death            = 0.001,
  prob_noreinfect       = 0.5
)

# Adding a small world population
agents_smallworld(
  model_surv,
  n = 10000,
  k = 5,
  d = FALSE,
  p = .01
  )
  
# Running and printing
run(model_surv, ndays = 100, seed = 1912)
model_surv 

# Plotting
plot(model_surv, main = "SURV Model")

}
\seealso{
epiworld-methods

Other Models: 
\code{\link{ModelDiffNet}()},
\code{\link{ModelSEIR}()},
\code{\link{ModelSEIRCONN}()},
\code{\link{ModelSEIRD}()},
\code{\link{ModelSEIRDCONN}()},
\code{\link{ModelSEIRMixing}()},
\code{\link{ModelSIR}()},
\code{\link{ModelSIRCONN}()},
\code{\link{ModelSIRD}()},
\code{\link{ModelSIRDCONN}()},
\code{\link{ModelSIRLogit}()},
\code{\link{ModelSIRMixing}()},
\code{\link{ModelSIS}()},
\code{\link{ModelSISD}()},
\code{\link{epiworld-data}}
}
\concept{Models}
