% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reload.R
\name{reload}
\alias{reload}
\title{Reload Idf data}
\usage{
reload(x, ...)
}
\arguments{
\item{x}{An object of class \link{Idd}, \link{IddObject}, \link{Idf}, \link{IdfObject}, \link{Epw},
\link{EplusJob}, \link{EplusGroupJob} or \link{ParametricJob} object. Any object of
other class will be directly returned without any modifications.}

\item{...}{further arguments passed to or from other methods. Currently not
used.}
}
\value{
The input object with its internal \code{\link[data.table:data.table]{data.table::data.table()}}s
properly initialized.
}
\description{
Reload Idf data
}
\details{
eplusr relies heavily on the \link[data.table:data.table]{data.table} package.
The core data of all main classes in eplusr are saved as
\code{\link[data.table:data.table]{data.table::data.table()}}s. This introduces a problem when loading saved
\link{Idf} objects or other class objects via an \verb{*.RDS} and \verb{*.RData} file on
disk: the stored \code{\link[data.table:data.table]{data.table::data.table()}}s lose their column
over-allocation. \code{reload()} is a helper function that calls
\code{\link[data.table:setDT]{data.table::setDT()}} on all internal \code{\link[data.table:data.table]{data.table::data.table()}}s to make
sure they are initialized properly.

It is recommended to call \code{reload()} on each \link{Idd}, \link{Idf} and other
class object in eplusr loaded with \code{\link[=readRDS]{readRDS()}} or \code{\link[=load]{load()}}, to make sure all
eplusr's functionaries works properly.
}
