#' @importFrom data.table data.table
NULL

# conversion_units_record {{{
# SI names {{{
si_name <- character(length = 154)
si_name[1] = "m"
si_name[2] = "m"
si_name[3] = "W"
si_name[4] = "W"
si_name[5] = "m3/s"
si_name[6] = "m3/s"
si_name[7] = "C"
si_name[8] = "kg/J"
si_name[9] = "Pa"
si_name[10] = "Pa"
si_name[11] = "Pa"
si_name[12] = "Pa"
si_name[13] = "W/m-K"
si_name[14] = "W/K"
si_name[15] = "deltaC"
si_name[16] = "m2"
si_name[17] = "K"
si_name[18] = "(kg/s)/W"
si_name[19] = "J/kg"
si_name[20] = "kgWater/kgDryAir"
si_name[21] = "kJ/kg"
si_name[22] = "lux"
si_name[23] = "kg/m3"
si_name[24] = "kg/s"
si_name[25] = "kg/s-m"
si_name[26] = "m3"
si_name[27] = "m3"
si_name[28] = "W/m2-K"
si_name[29] = "1/m"
si_name[30] = "J/kg-K"
si_name[31] = "J/m3-K"
si_name[32] = "m/s"
si_name[33] = "m/s"
si_name[34] = "m2-K/W"
si_name[35] = "W/m2"
si_name[36] = "A/K"
si_name[37] = "g/kg"
si_name[38] = "g/m-s"
si_name[39] = "g/m-s-K"
si_name[40] = "J/K"
si_name[41] = "J/kg-K2"
si_name[42] = "J/m3"
si_name[43] = "kg/kg-K"
si_name[44] = "kPa"
si_name[45] = "kPa"
si_name[46] = "m2/s"
si_name[47] = "m3/kg"
si_name[48] = "m3/m3"
si_name[49] = "N-s/m2"
si_name[50] = "V/K"
si_name[51] = "W/m-K2"
si_name[52] = "m3/s-m"
si_name[53] = "deg"
si_name[54] = "hr"
si_name[55] = "A"
si_name[56] = "dimensionless"
si_name[57] = "V"
si_name[58] = "A/V"
si_name[59] = "eV"
si_name[60] = "percent"
si_name[61] = "percentage (as a real decimal)"
si_name[62] = "s"
si_name[63] = "W/m2 or deg C"
si_name[64] = "W/m2, W or deg C"
si_name[65] = "1/K"
si_name[66] = "J/m2-K"
si_name[67] = "ohms"
si_name[68] = "cycles/hr"
si_name[69] = "kg/kg"
si_name[70] = "J/J"
si_name[71] = "g/GJ"
si_name[72] = "L/GJ"
si_name[73] = "m3/GJ"
si_name[74] = "m3/s-m2"
si_name[75] = "m3/s-person"
si_name[76] = "W/m2-K2"
si_name[77] = "g/MJ"
si_name[78] = "L/MJ"
si_name[79] = "m3/MJ"
si_name[80] = "W/W"
si_name[81] = "$/m2"
si_name[82] = "$"
si_name[83] = "$/kW"
si_name[84] = "$/m3"
si_name[85] = "years"
si_name[86] = "$/(W/K)"
si_name[87] = "$/(m3/s)"
si_name[88] = "W/m"
si_name[89] = "minutes"
si_name[90] = "cm"
si_name[91] = "K/m"
si_name[92] = "W/s"
si_name[93] = "kmol"
si_name[94] = "J"
si_name[95] = "GJ"
si_name[96] = "days"
si_name[97] = "kg/m2"
si_name[98] = "kg"
si_name[99] = "kmol/s"
si_name[100] = "percent/K"
si_name[101] = "kg/s2"
si_name[102] = "g/mol"
si_name[103] = "deltaJ/kg"
si_name[104] = "person/m2"
si_name[105] = "m2/person"
si_name[106] = "W/person"
si_name[107] = "W/person"
si_name[108] = "W/m2"
si_name[109] = "m3/person"
si_name[110] = "m3/hr-person"
si_name[111] = "m3/m2"
si_name[112] = "m3/hr-m2"
si_name[113] = "m3/hr"
si_name[114] = "s/m"
si_name[115] = "W/m2"
si_name[116] = "m2/m"
si_name[117] = "L/day"
si_name[118] = "L/kWh"
si_name[119] = "kg/Pa-s-m2"
si_name[120] = "m/hr"
si_name[121] = "Mode"
si_name[122] = "Control"
si_name[123] = "Availability"
si_name[124] = "rev/min"
si_name[125] = "W/(m3/s)"
si_name[126] = "W/m-K"
si_name[127] = "VA"
si_name[128] = "N-m"
si_name[129] = "m3/s-W"
si_name[130] = "cm2"
si_name[131] = "kg/m"
si_name[132] = "Pa"
si_name[133] = "m/yr"
si_name[134] = "1/hr"
si_name[135] = "ppm"
si_name[136] = "W/m-K3"
si_name[137] = "kg/m-s"
si_name[138] = "kg/m-s-K"
si_name[139] = "kg/m-s-K2"
si_name[140] = "J/kg-K3"
si_name[141] = "ms"
si_name[142] = "Ah"
si_name[143] = "deltaC/hr"
si_name[144] = "micron"
si_name[145] = "W/(m3/s)"
si_name[146] = "W/((m3/s)-Pa)"
si_name[147] = "m3/s-m"
si_name[148] = "m3/s-W"
si_name[149] = "m3/person"
si_name[150] = "m3/hr-person"
si_name[151] = "m3/m2"
si_name[152] = "m3/hr-m2"
si_name[153] = "m3/hr"
si_name[154] = "W/((m3/s)-Pa)"
# }}}

# IP names {{{
ip_name <- character(length = 154)
ip_name[1] = "ft"
ip_name[2] = "in"
ip_name[3] = "Btu/h"
ip_name[4] = "W"
ip_name[5] = "ft3/min"
ip_name[6] = "gal/min"
ip_name[7] = "F"
ip_name[8] = "lb/Btu"
ip_name[9] = "psi"
ip_name[10] = "inHg"
ip_name[11] = "inH2O"
ip_name[12] = "ftH2O"
ip_name[13] = "Btu-in/h-ft2-F"
ip_name[14] = "Btu/h-F"
ip_name[15] = "deltaF"
ip_name[16] = "ft2"
ip_name[17] = "R"
ip_name[18] = "(lbm/sec)/(Btu/hr)"
ip_name[19] = "Btu/lb"
ip_name[20] = "lbWater/lbDryAir"
ip_name[21] = "Btu/lb"
ip_name[22] = "foot-candles"
ip_name[23] = "lb/ft3"
ip_name[24] = "lb/s"
ip_name[25] = "lb/s-ft"
ip_name[26] = "ft3"
ip_name[27] = "gal"
ip_name[28] = "Btu/h-ft2-F"
ip_name[29] = "1/ft"
ip_name[30] = "Btu/lb-F"
ip_name[31] = "Btu/ft3-F"
ip_name[32] = "ft/min"
ip_name[33] = "miles/hr"
ip_name[34] = "ft2-F-hr/Btu"
ip_name[35] = "Btu/h-ft2"
ip_name[36] = "A/F"
ip_name[37] = "grains/lb"
ip_name[38] = "lb/ft-s"
ip_name[39] = "lb/ft-s-F"
ip_name[40] = "Btu/F"
ip_name[41] = "Btu/lb-F2"
ip_name[42] = "Btu/ft3"
ip_name[43] = "lb/lb-F"
ip_name[44] = "psi"
ip_name[45] = "inHg"
ip_name[46] = "ft2/s"
ip_name[47] = "ft3/lb"
ip_name[48] = "ft3/ft3"
ip_name[49] = "lbf-s/ft2"
ip_name[50] = "V/F"
ip_name[51] = "Btu/h-F2-ft"
ip_name[52] = "ft3/min-ft"
ip_name[53] = "deg"
ip_name[54] = "hr"
ip_name[55] = "A"
ip_name[56] = "dimensionless"
ip_name[57] = "V"
ip_name[58] = "A/V"
ip_name[59] = "eV"
ip_name[60] = "percent"
ip_name[61] = "percentage (as a real decimal)"
ip_name[62] = "s"
ip_name[63] = "unknown"
ip_name[64] = "unknown"
ip_name[65] = "1/F"
ip_name[66] = "Btu/ft2-F"
ip_name[67] = "ohms"
ip_name[68] = "cycles/hr"
ip_name[69] = "lb/lb"
ip_name[70] = "Btu/Btu"
ip_name[71] = "lb/MWh"
ip_name[72] = "gal/kWh"
ip_name[73] = "ft3/MWh"
ip_name[74] = "ft3/min-ft2"
ip_name[75] = "ft3/min-person"
ip_name[76] = "Btu/h-ft2-F2"
ip_name[77] = "lb/MWh"
ip_name[78] = "gal/kWh"
ip_name[79] = "ft3/kWh"
ip_name[80] = "Btuh/Btuh"
ip_name[81] = "$/ft2"
ip_name[82] = "$"
ip_name[83] = "$/(kBtuh/h)"
ip_name[84] = "$/ft3"
ip_name[85] = "years"
ip_name[86] = "$/(Btu/h-F)"
ip_name[87] = "$/(ft3/min)"
ip_name[88] = "Btu/h-ft"
ip_name[89] = "minutes"
ip_name[90] = "in"
ip_name[91] = "F/ft"
ip_name[92] = "W/s"
ip_name[93] = "kmol"
ip_name[94] = "Wh"
ip_name[95] = "ton-hrs"
ip_name[96] = "days"
ip_name[97] = "lb/ft2"
ip_name[98] = "lb"
ip_name[99] = "kmol/s"
ip_name[100] = "percent/F"
ip_name[101] = "lb/s2"
ip_name[102] = "lb/mol"
ip_name[103] = "deltaBtu/lb"
ip_name[104] = "person/ft2"
ip_name[105] = "ft2/person"
ip_name[106] = "Btu/h-person"
ip_name[107] = "W/person"
ip_name[108] = "W/m2"
ip_name[109] = "ft3/person"
ip_name[110] = "ft3/hr-person"
ip_name[111] = "ft3/ft2"
ip_name[112] = "ft3/hr-ft2"
ip_name[113] = "ft3/hr"
ip_name[114] = "s/ft"
ip_name[115] = "W/ft2"
ip_name[116] = "ft2/ft"
ip_name[117] = "pint/day"
ip_name[118] = "pint/kWh"
ip_name[119] = "lb/psi-s-ft2"
ip_name[120] = "ft/hr"
ip_name[121] = "Mode"
ip_name[122] = "Control"
ip_name[123] = "Availability"
ip_name[124] = "rev/min"
ip_name[125] = "W/(ft3/min)"
ip_name[126] = "Btu/h-ft-F"
ip_name[127] = "VA"
ip_name[128] = "lbf-in"
ip_name[129] = "(ft3/min)/(Btu/h)"
ip_name[130] = "inch2"
ip_name[131] = "lb/ft"
ip_name[132] = "Pa"
ip_name[133] = "inch/yr"
ip_name[134] = "1/hr"
ip_name[135] = "ppm"
ip_name[136] = "Btu/h-F3-ft"
ip_name[137] = "kg/m-s"
ip_name[138] = "kg/m-s-F"
ip_name[139] = "kg/m-s-F2"
ip_name[140] = "J/kg-K3"
ip_name[141] = "ms"
ip_name[142] = "Ah"
ip_name[143] = "deltaF/hr"
ip_name[144] = "micron"
ip_name[145] = "W/(gal/min)"
ip_name[146] = "W/((gal/min)-ftH20)"
ip_name[147] = "gal/min-ft"
ip_name[148] = "(gal/min)/(Btu/h)"
ip_name[149] = "gal/person"
ip_name[150] = "gal/hr-person"
ip_name[151] = "gal/ft2"
ip_name[152] = "gal/hr-ft2"
ip_name[153] = "gal/hr"
ip_name[154] = "W/((ft3/min)-inH2O)"
# }}}

# mult {{{
mult <- double(length = 154)
mult[1] = 3.28083989501312
mult[2] = 39.3700787401575
mult[3] = 3.4121412858518
mult[4] = 1
mult[5] = 2118.88000328931
mult[6] = 15850.3222370511
mult[7] = 1.8
mult[8] = 2325.83774250441
mult[9] = 1.45037743897283E-04
mult[10] = 0.00029613
mult[11] = 0.00401463
mult[12] = 0.00033455
mult[13] = 6.93481276005548
mult[14] = 1.89563404769544
mult[15] = 1.8
mult[16] = 10.7639104167097
mult[17] = 1.8
mult[18] = 0.646078115385742
mult[19] = 0.00042986
mult[20] = 1
mult[21] = 0.429925
mult[22] = 0.092902267
mult[23] = 0.062428
mult[24] = 2.20462247603796
mult[25] = 0.67196893069637
mult[26] = 35.3146667214886
mult[27] = 264.172037284185
mult[28] = 0.176110194261872
mult[29] = 0.3048
mult[30] = 2.39005736137667E-04
mult[31] = 1.49237004739337E-05
mult[32] = 196.850393700787
mult[33] = 2.2369362920544
mult[34] = 5.678263
mult[35] = 0.316957210776545
mult[36] = 0.555555555555556
mult[37] = 7
mult[38] = 0.000671968949659
mult[39] = 3.73574867724868E-04
mult[40] = 526.565
mult[41] = 1.32889924714692E-04
mult[42] = 2.68096514745308E-05
mult[43] = 0.555555555555556
mult[44] = 0.145038
mult[45] = 0.29523
mult[46] = 10.7639104167097
mult[47] = 16.018
mult[48] = 1
mult[49] = 2.08857913669065E-02
mult[50] = 0.555555555555556
mult[51] = 0.321418310071648
mult[52] = 645.89
mult[53] = 1
mult[54] = 1
mult[55] = 1
mult[56] = 1
mult[57] = 1
mult[58] = 1
mult[59] = 1
mult[60] = 1
mult[61] = 1
mult[62] = 1
mult[63] = 1
mult[64] = 1
mult[65] = 0.555555555555556
mult[66] = 4.89224766847393E-05
mult[67] = 1
mult[68] = 1
mult[69] = 1
mult[70] = 1
mult[71] = 7.93664091373665E-03
mult[72] = 9.51022349025202E-04
mult[73] = 127.13292
mult[74] = 196.85
mult[75] = 2118.6438
mult[76] = 0.097826
mult[77] = 7.93664091373665
mult[78] = 0.951022349025202
mult[79] = 127.13292
mult[80] = 1
mult[81] = 9.28939733269818E-02
mult[82] = 1
mult[83] = 0.293083235638921
mult[84] = 2.83127014102352E-02
mult[85] = 1
mult[86] = 0.52667614683731
mult[87] = 4.72000059660808E-04
mult[88] = 1.04072
mult[89] = 1
mult[90] = 0.3937
mult[91] = 0.54861322767449
mult[92] = 1
mult[93] = 1
mult[94] = 2.77777777777778E-04
mult[95] = 78.9889415481832
mult[96] = 1
mult[97] = 0.204794053596664
mult[98] = 2.2046
mult[99] = 1
mult[100] = 0.555555555555556
mult[101] = 2.2046
mult[102] = 0.0022046
mult[103] = 0.0004299
mult[104] = 9.28939733269818E-02
mult[105] = 10.764961
mult[106] = 3.4121412858518
mult[107] = 1
mult[108] = 1
mult[109] = 35.3146667214886
mult[110] = 35.3146667214886
mult[111] = 3.28083989501312
mult[112] = 3.28083989501312
mult[113] = 35.3146667214886
mult[114] = 0.3048
mult[115] = 0.09290304
mult[116] = 3.28083989501312
mult[117] = 2.11337629827348
mult[118] = 2.11337629827348
mult[119] = 1412.00523459398
mult[120] = 3.28083989501312
mult[121] = 1
mult[122] = 1
mult[123] = 1
mult[124] = 1
mult[125] = 0.0004719475
mult[126] = 0.577796066000163
mult[127] = 1
mult[128] = 8.85074900525547
mult[129] = 621.099127332943
mult[130] = 0.15500031000062
mult[131] = 0.67196893069637
mult[132] = 1
mult[133] = 39.3700787401575
mult[134] = 1
mult[135] = 1
mult[136] = 0.178565727817582
mult[137] = 0.67196893069637
mult[138] = 0.373316072609094
mult[139] = 0.207397818116164
mult[140] = 7.38277359526066E-05
mult[141] = 1
mult[142] = 1
mult[143] = 1.8
mult[144] = 1
mult[145] = 0.0000630902
mult[146] = 0.188582274697355
mult[147] = 4831.17821785317
mult[148] = 4645.27137336702
mult[149] = 264.172037284185
mult[150] = 264.172037284185
mult[151] = 24.5423853466941
mult[152] = 24.5423853466941
mult[153] = 264.172037284185
mult[154] = 0.117556910599482
# }}}

# offset {{{
offset <- double(length = 154)
offset[7] = 32
offset[19] = 7.686
# }}}

# alt {{{
alt <- logical(length = 154)
alt[2] = TRUE
alt[4] = TRUE
alt[6] = TRUE
alt[10] = TRUE
alt[11] = TRUE
alt[12] = TRUE
alt[45] = TRUE
alt[107] = TRUE
alt[108] = TRUE
alt[126] = TRUE
alt[132] = TRUE
alt[145] = TRUE
alt[147] = TRUE
alt[148] = TRUE
alt[149] = TRUE
alt[150] = TRUE
alt[151] = TRUE
alt[152] = TRUE
alt[153] = TRUE
alt[154] = TRUE
# }}}

# multi_unit_name {{{
multi_unit_name <- character(length = 154)
multi_unit_name[1] = "Distance"
multi_unit_name[3] = "Capacity"
multi_unit_name[4] = "Power"
multi_unit_name[5] = "VolumetricFlow"
multi_unit_name[7] = "Temperature"
multi_unit_name[9] = "Pressure"
multi_unit_name[13] = "Conductivity"
multi_unit_name[15] = "DeltaTemperature"
multi_unit_name[19] = "Enthalpy"
multi_unit_name[23] = "Density"
multi_unit_name[24] = "MassFlow"
multi_unit_name[28] = "ConvectionCoefficient"
multi_unit_name[30] = "SpecificHeat"
multi_unit_name[32] = "Velocity"
multi_unit_name[49] = "Viscosity"
multi_unit_name[53] = "Angle"
multi_unit_name[56] = "Dimensionless"
multi_unit_name[60] = "Percent"
multi_unit_name[94] = "Energy"
multi_unit_name[107] = "ActivityLevel"
multi_unit_name[120] = "PrecipitationRate"
multi_unit_name[121] = "Mode"
multi_unit_name[122] = "Control"
multi_unit_name[123] = "Availability"
multi_unit_name[129] = "VolumetricFlowPerPower"
multi_unit_name[144] = "Wavelength"
# }}}

unit_conv_table <- data.table::data.table(
    si_name, ip_name, mult, offset, alt, multi_unit_name
)
# }}}

# tablular_units_record {{{
# SI names {{{
si_name <- character(length = 115)
si_name[1] <- "%"
si_name[2] <- "?C"
si_name[3] <- "0=OFF 1=ON"
si_name[4] <- "0-NO  1-YES"
si_name[5] <- "1-YES 0-NO"
si_name[6] <- "A"
si_name[7] <- "ACH"
si_name[8] <- "ACH"
si_name[9] <- "BASE 10C"
si_name[10] <- "BASE 18C"
si_name[11] <- "C"
si_name[12] <- "CD/M2"
si_name[13] <- "DEG"
si_name[14] <- "FRAC"
si_name[15] <- "HOUR"
si_name[16] <- "HOURS"
si_name[17] <- "HR"
si_name[18] <- "HRS"
si_name[19] <- "J"
si_name[20] <- "J"
si_name[21] <- "J"
si_name[22] <- "J"
si_name[23] <- "J"
si_name[24] <- "J"
si_name[25] <- "J/KG"
si_name[26] <- "J/KG H2O"
si_name[27] <- "J/M2"
si_name[28] <- "K/M"
si_name[29] <- "KG"
si_name[30] <- "KG/KG"
si_name[31] <- "KG/M3"
si_name[32] <- "KG/S"
si_name[33] <- "KGWATER/KGAIR"
si_name[34] <- "KGWATER/SEC"
si_name[35] <- "KMOL/S"
si_name[36] <- "KMOL/SEC"
si_name[37] <- "KWH"
si_name[38] <- "L"
si_name[39] <- "L"
si_name[40] <- "LUM/W"
si_name[41] <- "LUX"
si_name[42] <- "M"
si_name[43] <- "M"
si_name[44] <- "M/S"
si_name[45] <- "M/S"
si_name[46] <- "M2"
si_name[47] <- "M2/PERSON"
si_name[48] <- "M3"
si_name[49] <- "M3"
si_name[50] <- "M3/M2"
si_name[51] <- "M3/S"
si_name[52] <- "M3/S"
si_name[53] <- "M3/S-M2"
si_name[54] <- "M3/S-PERSON"
si_name[55] <- "M3/S-PERSON"
si_name[56] <- "PA"
si_name[57] <- "PA"
si_name[58] <- "PA"
si_name[59] <- "PA"
si_name[60] <- "PA"
si_name[61] <- "PA"
si_name[62] <- "PA"
si_name[63] <- "PA"
si_name[64] <- "S"
si_name[65] <- "V"
si_name[66] <- "W"
si_name[67] <- "W"
si_name[68] <- "W"
si_name[69] <- "W"
si_name[70] <- "W"
si_name[71] <- "W/KG"
si_name[72] <- "W/KG H2O"
si_name[73] <- "W/K"
si_name[74] <- "W/M2"
si_name[75] <- "W/M2"
si_name[76] <- "W/M2-C"
si_name[77] <- "W/M2-K"
si_name[78] <- "W/W"
si_name[79] <- "deltaC"
si_name[80] <- "KJ/KG"
si_name[81] <- "W-S/M3"
si_name[82] <- "W-S/M3"
si_name[83] <- "~~$~~/m2"
si_name[84] <- "GJ"
si_name[85] <- "GJ"
si_name[86] <- "GJ"
si_name[87] <- "GJ"
si_name[88] <- "GJ"
si_name[89] <- "GJ"
si_name[90] <- "GJ"
si_name[91] <- "MJ/m2"
si_name[92] <- "MJ/m2"
si_name[93] <- "MJ/m2"
si_name[94] <- "MJ/m2"
si_name[95] <- "Invalid/Undefined"
si_name[96] <- ""
si_name[97] <- "W/C"
si_name[98] <- "DAY"
si_name[99] <- "MIN"
si_name[100] <- "HR/WK"
si_name[101] <- "$"
si_name[102] <- "$/UNIT ENERGY"
si_name[103] <- "KW"
si_name[104] <- "KGWATER/KGDRYAIR"
si_name[105] <- " "
si_name[106] <- "AH"
si_name[107] <- "CLO"
si_name[108] <- "J/KG-K"
si_name[109] <- "J/KGWATER"
si_name[110] <- "KGWATER/S"
si_name[111] <- "PPM"
si_name[112] <- "RAD"
si_name[113] <- "REV/MIN"
si_name[114] <- "NM"
si_name[115] <- "BTU/W-H"
# }}}

# IP names {{{
ip_name <- character(length = 115)
ip_name[1] <- "%"
ip_name[2] <- "F"
ip_name[3] <- "0=Off 1=On"
ip_name[4] <- "0-No  1-Yes"
ip_name[5] <- "1-Yes 0-No"
ip_name[6] <- "A"
ip_name[7] <- "ACH"
ip_name[8] <- "ach"
ip_name[9] <- "base 50F"
ip_name[10] <- "base 65F"
ip_name[11] <- "F"
ip_name[12] <- "cd/in2"
ip_name[13] <- "deg"
ip_name[14] <- "Frac"
ip_name[15] <- "Hour"
ip_name[16] <- "Hours"
ip_name[17] <- "hr"
ip_name[18] <- "hrs"
ip_name[19] <- "kBtu"
ip_name[20] <- "kWh"
ip_name[21] <- "therm"
ip_name[22] <- "MMBtu"
ip_name[23] <- "Wh"
ip_name[24] <- "ton-hrs"
ip_name[25] <- "Btu/lb"
ip_name[26] <- "Btu/lbWater"
ip_name[27] <- "kBtu/sqft"
ip_name[28] <- "F/ft"
ip_name[29] <- "lb"
ip_name[30] <- "lb/lb"
ip_name[31] <- "lb/ft3"
ip_name[32] <- "lb/s"
ip_name[33] <- "lbWater/lbAir"
ip_name[34] <- "lbWater/s"
ip_name[35] <- "kmol/s"
ip_name[36] <- "kmol/sec"
ip_name[37] <- "kWh"
ip_name[38] <- "gal"
ip_name[39] <- "ft3"
ip_name[40] <- "lum/W"
ip_name[41] <- "foot-candles"
ip_name[42] <- "ft"
ip_name[43] <- "in"
ip_name[44] <- "ft/min"
ip_name[45] <- "miles/hr"
ip_name[46] <- "ft2"
ip_name[47] <- "ft2/person"
ip_name[48] <- "ft3"
ip_name[49] <- "gal"
ip_name[50] <- "f3/f2"
ip_name[51] <- "ft3/min"
ip_name[52] <- "gal/min"
ip_name[53] <- "ft3/min-ft2"
ip_name[54] <- "ft3/min-person"
ip_name[55] <- "gal/min-person"
ip_name[56] <- "psi"
ip_name[57] <- "inHg"
ip_name[58] <- "inH2O"
ip_name[59] <- "ftH2O"
ip_name[60] <- "psi"
ip_name[61] <- "inHg"
ip_name[62] <- "inH2O"
ip_name[63] <- "ftH2O"
ip_name[64] <- "s"
ip_name[65] <- "V"
ip_name[66] <- "Btu/h"
ip_name[67] <- "W"
ip_name[68] <- "kW"
ip_name[69] <- "kBtuh"
ip_name[70] <- "ton"
ip_name[71] <- "kBtuh/lb"
ip_name[72] <- "kBtuh/lb"
ip_name[73] <- "Btu/h-F"
ip_name[74] <- "Btu/h-ft2"
ip_name[75] <- "kBtuh/ft2"
ip_name[76] <- "Btu/h-ft2-F"
ip_name[77] <- "Btu/h-ft2-F"
ip_name[78] <- "Btuh/Btuh"
ip_name[79] <- "deltaF"
ip_name[80] <- "Btu/lb"
ip_name[81] <- "W-min/ft3"
ip_name[82] <- "W-min/gal"
ip_name[83] <- "~~$~~/ft2"
ip_name[84] <- "kBtu"
ip_name[85] <- "kWh"
ip_name[86] <- "kWh"
ip_name[87] <- "therm"
ip_name[88] <- "MMBtu"
ip_name[89] <- "Wh"
ip_name[90] <- "ton-hrs"
ip_name[91] <- "kWh/ft2"
ip_name[92] <- "kBtu/ft2"
ip_name[93] <- "kBtu/ft2"
ip_name[94] <- "kWh/m2"
ip_name[95] <- "Invalid/Undefined"
ip_name[96] <- ""
ip_name[97] <- "Btu/h-F"
ip_name[98] <- "day"
ip_name[99] <- "min"
ip_name[100] <- "hr/wk"
ip_name[101] <- "$"
ip_name[102] <- "$/unit energy"
ip_name[103] <- "kW"
ip_name[104] <- "lbWater/lbDryAir"
ip_name[105] <- " "
ip_name[106] <- "Ah"
ip_name[107] <- "clo"
ip_name[108] <- "Btu/lbm-R"
ip_name[109] <- "Btu/lbWater"
ip_name[110] <- "lbWater/s"
ip_name[111] <- "ppm"
ip_name[112] <- "rad"
ip_name[113] <- "rev/min"
ip_name[114] <- "lbf-ft"
ip_name[115] <- "Btu/W-h"
# }}}

# mult {{{
mult <- double(length = 115)
mult[1] <- 1.0
mult[2] <- 1.8
mult[3] <- 1.0
mult[4] <- 1.0
mult[5] <- 1.0
mult[6] <- 1.0
mult[7] <- 1.0
mult[8] <- 1.0
mult[9] <- 1.8
mult[10] <- 1.8
mult[11] <- 1.8
mult[12] <- 0.000645160041625726
mult[13] <- 1.0
mult[14] <- 1.0
mult[15] <- 1.0
mult[16] <- 1.0
mult[17] <- 1.0
mult[18] <- 1.0
mult[19] <- 0.00000094845
mult[20] <- 0.000000277778
mult[21] <- 0.0000000094845
mult[22] <- 0.00000000094845
mult[23] <- 0.000277777777777778
mult[24] <- 0.0000000789847
mult[25] <- 0.00042956
mult[26] <- 0.0000004302105
mult[27] <- 0.00000008811404
mult[28] <- 0.54861322767449
mult[29] <- 2.2046
mult[30] <- 1.0
mult[31] <- 0.062428
mult[32] <- 2.2046
mult[33] <- 1.0
mult[34] <- 2.2046
mult[35] <- 1.0
mult[36] <- 1.0
mult[37] <- 1.0
mult[38] <- 0.264172037284185
mult[39] <- 0.0353146624712848
mult[40] <- 1.0
mult[41] <- 0.092902267
mult[42] <- 3.281
mult[43] <- 39.37
mult[44] <- 196.86
mult[45] <- 2.2369
mult[46] <- 10.764961
mult[47] <- 10.764961
mult[48] <- 35.319837041
mult[49] <- 264.172
mult[50] <- 3.281
mult[51] <- 2118.6438
mult[52] <- 15852.0
mult[53] <- 196.85
mult[54] <- 2118.6438
mult[55] <- 15852.0
mult[56] <- 0.0001450377
mult[57] <- 0.00029613
mult[58] <- 0.00401463
mult[59] <- 0.00033455
mult[60] <- 0.0001450377
mult[61] <- 0.00029613
mult[62] <- 0.00401463
mult[63] <- 0.00033455
mult[64] <- 1.0
mult[65] <- 1.0
mult[66] <- 3.412
mult[67] <- 1.0
mult[68] <- 0.001
mult[69] <- 0.00341442
mult[70] <- 0.0002843333
mult[71] <- 0.001547673
mult[72] <- 0.001547673
mult[73] <- 1.8987
mult[74] <- 0.316954237
mult[75] <- 0.000316954237
mult[76] <- 0.176085687
mult[77] <- 0.176085687
mult[78] <- 1.0
mult[79] <- 1.8
mult[80] <- 0.42956
mult[81] <- 1.0 / 2118.6438
mult[82] <- 1.0 / 15852
mult[83] <- 1.0 / 10.764961
mult[84] <- 0.00000094845 * 1000000000
mult[85] <- 0.000000277778 * 1000000000
mult[86] <- 0.000000277778 * 1000000000
mult[87] <- 0.0000000094845 * 1000000000
mult[88] <- 0.00000000094845 * 1000000000
mult[89] <- 0.000277777777777778 * 1000000000
mult[90] <- 0.0000000789847 * 1000000000
mult[91] <- 0.277777777777778 / 10.764961
mult[92] <- 0.94708628903179 / 10.764961
mult[93] <- 0.94708628903179 / 10.764961
mult[94] <- 0.27777777777778
mult[95] <- 1.0
mult[96] <- 1.0
mult[97] <- 1.8987
mult[98] <- 1.0
mult[99] <- 1.0
mult[100] <- 1.0
mult[101] <- 1.0
mult[102] <- 1.0
mult[103] <- 1.0
mult[104] <- 1.0
mult[105] <- 1.0
mult[106] <- 1.0
mult[107] <- 1.0
mult[108] <- 0.000238845896627
mult[109] <- 0.0000004302105
mult[110] <- 2.2046
mult[111] <- 1.0
mult[112] <- 1.0
mult[113] <- 1.0
mult[114] <- 0.737562149277
mult[115] <- 1.0
# }}}

# offset {{{
offset <- double(length = 115)
offset[2] <- 32.0
offset[11] <- 32.0
offset[25] <- 7.6736
offset[80] <- 7.6736
# }}}

# hint {{{
hint <- character(115)
hint[20] <- "ELEC"
hint[21] <- "GAS"
hint[24] <- "COOL"
hint[38] <- "WATER"
hint[49] <- "WATER"
hint[52] <- "WATER"
hint[67] <- "ELEC"
hint[70] <- "COOL"
hint[82] <- "WATER"
hint[85] <- "CONSUMP"
hint[86] <- "ELEC"
hint[87] <- "GAS"
hint[90] <- "COOL"
hint[91] <- "ELEC"
hint[92] <- "GAS"
hint[92] <- "ADDITIONAL"
# }}}

# several {{{
several <- logical(115)
several[19] <- TRUE
several[20] <- TRUE
several[21] <- TRUE
several[22] <- TRUE
several[23] <- TRUE
several[24] <- TRUE
several[38] <- TRUE
several[39] <- TRUE
several[42] <- TRUE
several[43] <- TRUE
several[44] <- TRUE
several[45] <- TRUE
several[48] <- TRUE
several[49] <- TRUE
several[51] <- TRUE
several[52] <- TRUE
several[54] <- TRUE
several[55] <- TRUE
several[56] <- TRUE
several[57] <- TRUE
several[58] <- TRUE
several[59] <- TRUE
several[60] <- TRUE
several[61] <- TRUE
several[62] <- TRUE
several[63] <- TRUE
several[66] <- TRUE
several[67] <- TRUE
several[68] <- TRUE
several[69] <- TRUE
several[70] <- TRUE
several[74] <- TRUE
several[75] <- TRUE
several[81] <- TRUE
several[82] <- TRUE
several[84] <- TRUE
several[85] <- TRUE
several[86] <- TRUE
several[87] <- TRUE
several[88] <- TRUE
several[89] <- TRUE
several[90] <- TRUE
several[91] <- TRUE
several[92] <- TRUE
several[93] <- TRUE
several[94] <- TRUE
# }}}

tabular_unit_conv_table <- data.table::data.table(
    si_name, ip_name, mult, offset, hint, several
)
# }}}
