% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aki.R
\name{aki_UO}
\alias{aki_UO}
\alias{aki_UO.data.frame}
\alias{aki_UO.units}
\alias{aki_UO.numeric}
\title{AKI Staging based on Urine Output}
\usage{
aki_UO(...)

\method{aki_UO}{data.frame}(.data, UO, dttm, pt_id, ...)

\method{aki_UO}{units}(UO, dttm, pt_id, ...)

\method{aki_UO}{numeric}(UO, dttm, pt_id, ...)
}
\arguments{
\item{...}{Further optional arguments}

\item{.data}{(data.frame) A data.frame, optional}

\item{UO}{Urine output
column name, or vector of units or numeric if \code{.data} is not provided}

\item{dttm}{DateTime
column name, or vector of POSIXct if \code{.data} is not provided}

\item{pt_id}{Patient ID
column name, or vector of characters or factors if \code{.data} is not provided}
}
\value{
(ordered factor) AKI stages
}
\description{
Using KDIGO Clinical Practice Guideline for
Acute Kidney Injury
Volume 2 | Issue 1 | March 2012
}
\details{
\itemize{
\item{AKI Stage 1: <0.5 ml/kg/h for 6–12 hours}
\item{AKI Stage 2: <0.5 ml/kg/h for \eqn{\ge}12 hours}
\item{AKI Stage 3: <0.3 ml/kg/h for \eqn{\ge}24 hours OR Anuria for \eqn{\ge}12 hours}
}

See \url{https://kdigo.org/guidelines/acute-kidney-injury/} for more details.
}
\examples{
aki_UO(aki_pt_data, UO = "UO_", dttm = "dttm_", pt_id = "pt_id_")

aki_pt_data \%>\%
  dplyr::mutate(aki = aki_UO(UO = UO_, dttm = dttm_, pt_id = pt_id_))
}
