% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/superiorityAnalysis.R
\name{superiorityAnalysis}
\alias{superiorityAnalysis}
\title{Superiority Analysis Across Interventions for CRT, MST, or SRT Designs}
\usage{
superiorityAnalysis(
  method = c("crt", "mst", "srt"),
  data,
  outcome = "posttest",
  interventions = "interventions",
  Random = "schools",
  Nsim = 10000,
  Threshold = 0.05,
  refintervention = 1,
  SupThreshold = 0.8,
  continuous_covariates = NULL,
  categorical_covariates = NULL
)
}
\arguments{
\item{method}{The trial design type: "crt", "mst", or "srt".}

\item{data}{A data frame containing the variables including outcome, predictors, the clustering variable, and the intervention.}

\item{outcome}{The name of the outcome (post-test) variable.}

\item{interventions}{A string specifying the intervention variable.}

\item{Random}{The name of the clustering variable (e.g., schools or sites) for CRT and MST designs.}

\item{Nsim}{Number of MCMC iterations to be performed. A minimum of 10,000 is recommended to ensure convergence.}

\item{Threshold}{The effect size threshold for posterior computation (default = 0.05).}

\item{refintervention}{The value of the intervention used as the reference group (default = 1).}

\item{SupThreshold}{The minimum posterior probability threshold to declare superiority (default = 0.8).}

\item{continuous_covariates}{A character vector specifying the names of continuous covariates.}

\item{categorical_covariates}{A character vector specifying the names of categorical covariates (converted to factors).}
}
\value{
A \code{data.frame} with columns:
\itemize{
\item \code{Intervention}: Intervention group identifier.
\item \code{ProbES}: Posterior probability of superiority over the reference intervention.
\item \code{Superiority}: Label indicating \code{"Superior"}, \code{"Not Superior"}, or \code{"Reference"}.
}
}
\description{
This function performs a Bayesian superiority analysis, comparing each intervention against a reference
intervention, across cluster randomized trials (CRT), multisite trials (MST) or simple randomized trials (SRT).
}
\details{
The effect size is estimated against a reference intervention, which by default is intervention 1 but can be reassigned to any other intervention, including the control (refintervention = 0).
}
\examples{
\donttest{
###Superiority analysis of cluster randomized trial###
data(crt4armSimData)
superiorityAnalysis(method = "crt", data = crt4armSimData, outcome = "posttest",
interventions = "interventions", Random = "schools", Nsim = 10000, refintervention = 2,
Threshold = 0.05, SupThreshold = 0.8,continuous_covariates = c("pretest"),
categorical_covariates = c("gender", "ethnicity"))

###Superiority analysis of multisite trial###
data(mst4armSimData)
superiorityAnalysis(method = "mst", data = mst4armSimData, outcome = "posttest",
interventions = "interventions", Random = "schools", Nsim = 10000, refintervention = 2,
Threshold = 0.05, SupThreshold = 0.8,continuous_covariates = c("pretest"),
categorical_covariates = c("gender", "ethnicity"))

###Superiority analysis of simple randomized trial###
data(srt4armSimData)
superiorityAnalysis(method = "srt", data = srt4armSimData, outcome = "posttest",
interventions = "interventions", Nsim = 10000, refintervention = 2,
Threshold = 0.05, SupThreshold = 0.8,continuous_covariates = c("pretest"),
categorical_covariates = c("gender", "ethnicity"))

}

}
\seealso{
\code{\link[eefAnalytics]{crtBayes}}, \code{\link[eefAnalytics]{mstBayes}}, \code{\link[eefAnalytics]{srtBayes}} functions from the \pkg{eefAnalytics} package
}
