% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eqps.R
\name{ps}
\alias{ps}
\title{Calculate the Probablility of Superiority}
\usage{
ps(
  pre,
  post,
  version = NULL,
  ignore.invalid = TRUE,
  dimensions = .get_dimension_names(),
  digits = 2
)
}
\arguments{
\item{pre}{data.frame, numeric or character. For data.frame default column 
names should be MO, SC, UA, PD and AD representing Mobility, Self-care, 
Usual activities, Pain/discomfort and Anxiety/depression. Vector using five 
digit format can also be used.}

\item{post}{data.frame, numeric or character. For data.frame default column 
names should be MO, SC, UA, PD and AD representing Mobility, Self-care, 
Usual activities, Pain/discomfort and Anxiety/depression. Vector using five 
digit format can also be used.}

\item{version}{string of value "3L" or "5L" to indicate instrument version.}

\item{ignore.invalid}{boolean whether to ignore invalid scores. TRUE returns NA, FALSE 
throws an error.}

\item{dimensions}{character vector, specifying "dimension" column names. Defaults 
are "MO", "SC", "UA", "PD" and "AD".}

\item{digits}{numeric specifying the number of decimal places. Defaults to 2.}
}
\value{
a list of Probability of Superiority scores by dimension.
}
\description{
Calculate the Probablility of Superiority (PS) for the dimensions of two EQ-5D 
datasets. Score is less than 0.5 if more patients deteriorate than improve, 0.5 
if the same number of patients improve and deteriorate or do not change and 
greater than 0.5 if more patients improve than deteriorate.
}
\examples{
dat <- read.csv(system.file("extdata", "eq5d3l_example.csv", package="eq5d"))

pre <- dat[dat$Group=="Group1",][1:50,]
post <- dat[dat$Group=="Group2",][1:50,]

ps(pre, post, version="3L")

}
