% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine.networks.R
\name{uncombine_network}
\alias{uncombine_network}
\title{Split up a network into a list of subgraphs}
\usage{
uncombine_network(
  nw,
  split.vattr = nw \%n\% ".blockID.vattr",
  names.vattr = nw \%n\% ".blockName.vattr",
  use.subnet.cache = FALSE
)
}
\arguments{
\item{nw}{a \code{\link[network:network]{network::network}} created by \code{\link[=combine_networks]{combine_networks()}}.}

\item{split.vattr}{name of the vertex attribute on which to split,
defaulting to the value of the \code{".blockID.vattr"} network
attribute.}

\item{names.vattr}{optional name of the vertex attribute to use as
network names in the output list, defaulting to the value of the
\code{".blockName.vattr"} network attribute.}

\item{use.subnet.cache}{whether to use subnet cache if available;
this is only safe to do if the network is \emph{not} used for its
edges but only for its vertex and network attributes.}
}
\value{
a list of \code{\link[network:network]{network::network}}s containing subgraphs on \code{split.vattr}. In particular,
\itemize{
\item their basic properties (directedness and bipartednes) are the same as those of the input network;
\item vertex attributes are split;
\item edge attributes are assigned to their respective edges in
the returned networks.
}

If \code{split.vattr} is a vector, only the first element is used and it's "popped".
}
\description{
Given a network created by \code{\link[=combine_networks]{combine_networks()}}, \code{\link[=uncombine_network]{uncombine_network()}} returns a list of networks,
preserving attributes that can be preserved.
}
\examples{

data(samplk)

o1 <- combine_networks(list(samplk1, samplk2, samplk3))
image(as.matrix(o1))

ol <- uncombine_network(o1)

}
\seealso{
\code{\link[=split.network]{split.network()}}
}
