% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.R
\name{attrcov-ergmTerm}
\alias{attrcov-ergmTerm}
\alias{InitErgmTerm.attrcov}
\title{Edge covariate by attribute pairing}
\usage{
# binary: attrcov(attr, mat)
}
\arguments{
\item{attr}{quantitative attribute (see Specifying Vertex attributes and Levels (\code{?nodal_attributes}) for details.)}

\item{mat}{a matrix of covariates with the same dimensions as a mixing matrix for \code{attr}}
}
\description{
This term adds one statistic to the model, equal to the sum of the covariate values
for each edge appearing in the network, where the covariate value for a given edge is determined by its mixing type on
\code{attr}. Undirected networks are regarded as having undirected mixing, and it is assumed that \code{mat} is symmetric
in that case.

This term can be useful for simulating large networks with many mixing types, where \code{nodemix} would be slow due to
the large number of statistics, and \code{edgecov} cannot be used because an adjacency matrix would be too big.
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.
}
\concept{directed}
\concept{dyad-independent}
\concept{undirected}
