% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.R
\name{idegree-ergmTerm}
\alias{idegree-ergmTerm}
\alias{InitErgmTerm.idegree}
\title{In-degree}
\usage{
# binary: idegree(d, by=NULL, homophily=FALSE, levels=NULL)
}
\arguments{
\item{d}{a vector of distinct integers}

\item{by, homophily}{the optional argument \code{by} specifies a vertex attribute (see Specifying
Vertex attributes and Levels (\code{?nodal_attributes}) for details).
If this is specified and \code{homophily} is \code{TRUE} ,
then degrees are calculated using the subnetwork consisting of only
edges whose endpoints have the same value of the \code{by} attribute.
If \code{by} is specified and
\code{homophily} is \code{FALSE} (the default), then separate degree range
statistics are calculated for nodes having each separate
value of the attribute.}

\item{levels}{TODO (See Specifying Vertex
attributes and Levels (\code{\link[=nodal_attributes]{?nodal_attributes}}) for details.)}
}
\description{
This term adds one network statistic to
the model for each element in \code{d} ; the \eqn{i} th such statistic equals
the number of nodes in the network of in-degree \code{d[i]} , i.e. the number
of nodes with exactly \code{d[i]} in-edges.
This term can only be used with directed networks; for undirected networks
see \code{degree} .
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "idegree", "subsection")}
}
\concept{categorical nodal attribute}
\concept{directed}
\concept{frequently-used}
