% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{g4}
\alias{g4}
\title{Goodreau's four node network as a "network" object}
\source{
Steve Goodreau
}
\usage{
data(g4)
}
\description{
This is an example thought of by Steve Goodreau. It is a directed network of
four nodes and five ties stored as a \code{\link[network]{network}} object.
}
\details{
It is interesting because the maximum likelihood estimator of the model with
out degree 3 in it exists, but the maximum psuedolikelihood estimator does
not.
}
\examples{

data(g4)
summary(ergm(g4 ~ odegree(3), estimate="MPLE"))
summary(ergm(g4 ~ odegree(3), control=control.ergm(init=0)))

}
\seealso{
florentine, network, plot.network, ergm
}
\keyword{datasets}
