% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.R
\name{triadcensus-ergmTerm}
\alias{triadcensus-ergmTerm}
\alias{InitErgmTerm.triadcensus}
\title{Triad census}
\usage{
# binary: triadcensus(levels)
}
\arguments{
\item{levels}{For directed networks, specify a set of terms to add other than the default value of \code{1:15}.
attributes and Levels (\code{\link[=nodal_attributes]{?nodal_attributes}}) for details.)}
}
\description{
For a directed network, this term adds one network statistic for each of
an arbitrary subset of the 16 possible types of triads categorized by
Davis and Leinhardt (1972) as \verb{003, 012, 102, 021D, 021U, 021C, 111D, } \verb{	111U, 030T, 030C, 201, 120D, 120U, 120C, 210,} and \code{300} . Note that at
least one category should be dropped; otherwise a linear dependency will
exist among the 16 statistics, since they must sum to the total number of
three-node sets. By default, the category \code{003} , which is the category
of completely empty three-node sets, is dropped. This is considered category
zero, and the others are numbered 1 through 15 in the order given above. Each statistic is the count of the corresponding triad
type in the network. For details on the 16 types, see \code{?triad.classify}
in the \CRANpkg{sna} package, on which this code is based. For an undirected
network, the triad census is over the four types defined by the number of
ties (i.e., 0, 1, 2, and 3).
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "triadcensus", "subsection")}
}
\concept{directed}
\concept{triad-related}
\concept{undirected}
