% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single.R
\name{check_bool}
\alias{check_bool}
\title{Check If Argument Is Single Logical}
\usage{
check_bool(
  x,
  name = NULL,
  general = NULL,
  specific = NULL,
  supplement = NULL,
  ...
)
}
\arguments{
\item{x}{The argument to check, which can be any object.}

\item{name}{A single character which gives the argument's name.
The name is used in the error message. By default, the name of the
argument passed to argument \code{x} is captured automatically.}

\item{general}{Optional. A single character which is used to give a
general statement of the error incurred. By default, this is generated
automatically.}

\item{specific}{Optional. A single character which gives a detailed
description of the error. By default, this is generated automatically.
Can be turned off with \code{character(0)}.}

\item{supplement}{Optional. A (named) character vector which gives some
additional information about the error. The names are used to create
bullets, see \code{\link[=Statement]{Statement()}}. By default, this is left empty.}

\item{...}{Optional. Additional arguments passed to \code{\link[rlang:abort]{rlang::abort()}},
which is called internally.}
}
\value{
An invisible \code{NULL} if the argument is valid, or an error message
is generated.
}
\description{
Check if an argument is \code{TRUE} or \code{FALSE}, and if not,
generate an error message.
}
\examples{
x <- TRUE
check_bool(x)

\dontrun{
# `x` must have type logical
x <- 1
check_bool(x)

# `x` must have length 1
x <- c(TRUE, FALSE)
check_bool(x)

# `x` must not be `NA`
x <- NA
check_bool(x)
}
}
\seealso{
"Examples" section in \code{\link[=check_type]{check_type()}} for how to customize
error message and how to add and retrieve additional arguments.

\code{vignette("erify")} for a gentle introduction to this package.
}
