% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-classes.R
\name{check_binary_classes}
\alias{check_binary_classes}
\title{Check Binary Operator's Arguments' Classes}
\usage{
check_binary_classes(
  x,
  y,
  valid_x,
  valid_y = NULL,
  operator = NULL,
  commutative = NULL,
  general = NULL,
  specific = NULL,
  supplement = NULL,
  ...
)
}
\arguments{
\item{x, y}{The argument to check, which can be any object.}

\item{valid_x, valid_y}{A character vector which contains the valid classes.
\code{valid_y} is assigned \code{valid_x}, if not specified.}

\item{operator}{Optional. A single character which represents the binary
operator.}

\item{commutative}{\code{TRUE} or \code{FALSE} which indicates if arguments \code{x} and
\code{y} can be swapped around. The default value is \code{TRUE}.}

\item{general}{Optional. A single character which is used to give a
general statement of the error incurred. By default, this is generated
automatically.}

\item{specific}{Optional. A single character which gives a detailed
description of the error. \code{\link[glue:glue]{glue::glue()}} syntax can be used, see
"Examples" section. By default, this is generated automatically.}

\item{supplement}{Optional. A (named) character vector which gives some
additional information about the error. The names are used to create
bullets, see \code{\link[=throw]{throw()}}. By default, this is left empty.}

\item{...}{Optional. Additional arguments which can be retrieved with
\code{\link[=tryCatch]{tryCatch()}}.}
}
\value{
returns an invisible \code{NULL} if the argument is valid, or
generates an error message.
}
\description{
Check if the arguments of a binary operator have valid
classes, and if not, generate an error message.
}
\examples{
\dontrun{
x <- 1
class(x) <- c("a", "b")

y <- 2
class(y) <- c("c", "d")

check_binary_classes(x, y, c("d", "e"))
check_binary_classes(x, y, c("d", "e"), operator = "+")

check_binary_classes(x, y, c("d", "e"), c("a", "f"))
check_binary_classes(x, y, c("d", "e"), c("a", "f"), commutative = FALSE)

# customize error message with `glue::glue()` syntax
check_binary_classes(
  x, y, c("d", "e"),
  specific = "Left: {feature_x[1]}, {feature_x[2]}.",
  supplement = "Right: {feature_y[1]}, {feature_y[2]}."
)
}
}
\seealso{
"Examples" section in \code{\link[=check_type]{check_type()}} for how to customize
error message and how to add and retrieve additional arguments.

\code{vignette("erify")} for a gentle introduction to this package.
}
