% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-positive.R
\name{check_positive}
\alias{check_positive}
\title{Check If Argument Is Single Positive Number}
\usage{
check_positive(
  x,
  name = NULL,
  general = NULL,
  specific = NULL,
  supplement = NULL,
  zero = FALSE,
  ...
)
}
\arguments{
\item{x}{The argument to check, which can be any object.}

\item{name}{A single character which gives the argument's name.
The name is used in the error message. By default, the name of the
argument passed to argument \code{x} is captured automatically.}

\item{general}{Optional. A single character which is used to give a
general statement of the error incurred. By default, this is generated
automatically.}

\item{specific}{Optional. A single character which gives a detailed
description of the error. By default, this is generated automatically.}

\item{supplement}{Optional. A (named) character vector which gives some
additional information about the error. The names are used to create
bullets, see \code{\link[=throw]{throw()}}. By default, this is left empty.}

\item{zero}{Optional. \code{TRUE} or \code{FALSE} which indicates if zero is
acceptable. The default value is \code{FALSE}.}

\item{...}{Optional. Additional arguments which can be retrieved with
\code{\link[=tryCatch]{tryCatch()}}.}
}
\value{
returns an invisible \code{NULL} if the argument is valid, or
generates an error message.
}
\description{
Check if an argument is a single positive number,
and if not, generate an error message.
}
\examples{
x <- 1.1
check_positive(x)

x <- 1L
check_positive(x)

\dontrun{
# `x` must be a numeric
x <- "1"
check_positive(x)

# `x` must have length 1
x <- 1:2
check_positive(x)

# `x` must not be `NA`
x <- NA_integer_
check_positive(x)

# `x` must be larger than 0
x <- -1
check_positive(x)

# make `0` acceptable
x <- 0
check_positive(x)
check_positive(x, zero = TRUE)
}
}
\seealso{
"Examples" section in \code{\link[=check_type]{check_type()}} for how to customize
error message and how to add and retrieve additional arguments.

\code{vignette("erify")} for a gentle introduction to this package.
}
