% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/errors.R
\docType{package}
\name{errors}
\alias{errors}
\alias{errors-package}
\alias{errors}
\alias{errors}
\alias{errors_max}
\alias{errors}
\alias{errors_min}
\alias{errors}
\alias{errors<-}
\alias{errors}
\alias{set_errors}
\alias{errors}
\alias{as.errors}
\title{\pkg{errors}: Error Propagation for R Vectors}
\usage{
errors(x)

errors_max(x)

errors_min(x)

errors(x) <- value

set_errors(x, value = 0)

as.errors(x, value = 0)
}
\arguments{
\item{x}{a numeric object, or object of class \code{errors}.}

\item{value}{a numeric vector of length 1 or the same length as \code{x}.}
}
\description{
Support for painless automatic error propagation in numerical operations.
Errors are automatically propagated when you operate with \code{errors}
objects, or with \code{errors} and numeric objects (then numeric values are
automatically coerced to errors with zero error).
\cr\cr This package treats errors as coming from Gaussian, linear and independent
sources, and propagates them using the first-order Taylor series method for
propagation of uncertainty. Although the above assumptions are valid in a wide
range of applications in science and engineering, the practitioner should
evaluate whether they apply for each particular case.
}
\details{
\code{errors} returns a vector of errors. \code{errors_max}
(\code{errors_min}) returns the values plus (minus) the errors.

\code{`errors<-`} sets the error values (and converts \code{x} into an object
of class \code{errors}). \code{set_errors} is a pipe-friendly version of
\code{`errors<-`} and returns an object of class \code{errors}. \code{as.errors}
is an alias for \code{set_errors}.
}
\examples{
x = 1:3
class(x)
x
errors(x) <- 0.1
class(x)
x

(x <- set_errors(x, seq(0.1, 0.3, 0.1)))
errors_max(x)
errors_min(x)

}
\seealso{
\code{\link{groupGeneric.errors}}, \code{\link{mean.errors}}.
\code{\link{Extract.errors}}, \code{\link{c}}, \code{\link{rep}}, \code{\link{cbind.errors}}.
\code{\link{format.errors}}, \code{\link{print.errors}}, \code{\link{plot.errors}}.
\code{\link{as.data.frame.errors}}, \code{\link{as.matrix.errors}}, \code{\link{t}}.
}
\author{
Iñaki Ucar
}
