% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esDesign.R
\name{SigP}
\alias{SigP}
\title{Commonly used \eqn{\alpha}-spending functions}
\usage{
SigP(alpha, Info, esFunction = "Pocock", gamma = 1)
}
\arguments{
\item{alpha}{The overall Type I error rate}

\item{Info}{The fraction of the observed information}

\item{esFunction}{The specific \eqn{\alpha}-spending function. For example,
\code{esFunction = "Pocock"} for the Pocock method,
\code{esFunction = "LD"} for the Lan-Demets method,
\code{esFunction = "OF"} for the O'Brein-Fleming method, and
\code{esFunction = "Power"} for the Power method.}

\item{gamma}{The parameter used in the Power method. The default value is
\code{gamma = 1}.}
}
\value{
The reduced significant level
}
\description{
The \code{SigP()} is used to calculate the reduced significant
   level based on several widely used \eqn{\alpha}-spending functions, such as
   the "Pocock", "Lan-DeMets", "O`Brein-Fleming" and "Power" functions.
}
\examples{
alpha <- 0.05
Info <- 0.5
esFunction = "OF"
SigP(alpha = alpha, Info = Info, esFunction = esFunction)
}
