% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trialr_efftox_selector.R
\name{get_trialr_efftox}
\alias{get_trialr_efftox}
\title{Get an object to fit the EffTox model using the trialr package.}
\usage{
get_trialr_efftox(
  parent_selector_factory = NULL,
  real_doses,
  efficacy_hurdle,
  toxicity_hurdle,
  p_e,
  p_t,
  eff0,
  tox1,
  eff_star,
  tox_star,
  priors,
  ...
)
}
\arguments{
\item{parent_selector_factory}{optional object of type
\code{\link{selector_factory}} that is in charge of dose selection before
this class gets involved. Leave as NULL to just use EffTox from the start.}

\item{real_doses}{A vector of numbers, the doses under investigation. They
should be ordered from lowest to highest and be in consistent units.
E.g. to conduct a dose-finding trial of doses 10mg, 20mg and 50mg, use
c(10, 20, 50).}

\item{efficacy_hurdle}{Minimum acceptable efficacy probability.
A number between 0 and 1.}

\item{toxicity_hurdle}{Maximum acceptable toxicity probability.
A number between 0 and 1.}

\item{p_e}{Certainty required to infer a dose is acceptable with regards to
being probably efficacious; a number between 0 and 1.}

\item{p_t}{Certainty required to infer a dose is acceptable with regards to
being probably tolerable; a number between 0 and 1.}

\item{eff0}{Efficacy probability required when toxicity is impossible;
a number between 0 and 1 (see Details).}

\item{tox1}{Toxicity probability permitted when efficacy is guaranteed;
a number between 0 and 1 (see Details).}

\item{eff_star}{Efficacy probability of an equi-utility third point (see
Details).}

\item{tox_star}{Toxicity probability of an equi-utility third point (see
Details).}

\item{priors}{instance of class \code{\link{trialr}{efftox_priors}}, the
hyperparameters for normal priors on the six model parameters.}

\item{...}{Extra args are passed to \code{\link[trialr]{stan_efftox}}.}
}
\value{
an object of type \code{\link{selector_factory}} that can fit the
EffTox model to outcomes.
}
\description{
This function returns an object that can be used to fit the EffTox model for
phase I/II dose-finding using methods provided by the trialr package.
}
\examples{
efftox_priors <- trialr::efftox_priors
p <- efftox_priors(alpha_mean = -7.9593, alpha_sd = 3.5487,
                   beta_mean = 1.5482, beta_sd = 3.5018,
                   gamma_mean = 0.7367, gamma_sd = 2.5423,
                   zeta_mean = 3.4181, zeta_sd = 2.4406,
                   eta_mean = 0, eta_sd = 0.2,
                   psi_mean = 0, psi_sd = 1)
real_doses = c(1.0, 2.0, 4.0, 6.6, 10.0)
model <- get_trialr_efftox(real_doses = real_doses,
                           efficacy_hurdle = 0.5, toxicity_hurdle = 0.3,
                           p_e = 0.1, p_t = 0.1,
                           eff0 = 0.5, tox1 = 0.65,
                           eff_star = 0.7, tox_star = 0.25,
                           priors = p, iter = 1000, chains = 1, seed = 2020)

}
\references{
Thall, P., & Cook, J. (2004). Dose-Finding Based on Efficacy-Toxicity
Trade-Offs. Biometrics, 60(3), 684-693.
https://doi.org/10.1111/j.0006-341X.2004.00218.x

Thall, P., Herrick, R., Nguyen, H., Venier, J., & Norris, J. (2014).
Effective sample size for computing prior hyperparameters in Bayesian
phase I-II dose-finding. Clinical Trials, 11(6), 657-666.
https://doi.org/10.1177/1740774514547397

Brock, K. (2020). trialr: Clinical Trial Designs in 'rstan'.
R package version 0.1.5. https://github.com/brockk/trialr

Brock, K. (2019). trialr: Bayesian Clinical Trial Designs in R and Stan.
arXiv preprint arXiv:1907.00161.
}
