% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_mdiff.R
\name{plot_mdiff}
\alias{plot_mdiff}
\title{Plots for comparing continuous outcome variables between conditions}
\usage{
plot_mdiff(
  estimate,
  effect_size = c("mean", "median"),
  data_layout = c("random", "swarm", "none"),
  data_spread = 0.15,
  error_layout = c("halfeye", "eye", "gradient", "none"),
  error_scale = 0.3,
  error_nudge = 0.4,
  error_normalize = c("groups", "all", "panels"),
  difference_axis_units = c("raw", "sd"),
  difference_axis_breaks = 5,
  difference_axis_space = 1,
  simple_contrast_labels = TRUE,
  ylim = c(NA, NA),
  ybreaks = 5,
  rope = c(NA, NA),
  rope_units = c("raw", "sd"),
  ggtheme = NULL
)
}
\arguments{
\item{estimate}{An esci-estimate object generated by an estimate_mdiff_
function}

\item{effect_size}{Optional; one of 'mean' or 'median' to determine the
measure of central tendency plotted.  Note that median is only available if
the estimate was generated from raw data.  Defaults to 'mean'}

\item{data_layout}{Optional; one of 'random', 'swarm', or 'none' to determine
how raw data (if available) will be displayed.  Defaults to 'random'}

\item{data_spread}{Optional numeric determining width raw data will use
in each condition.  Defaults to 0.15 (relative to 1 unit per condition)}

\item{error_layout}{Optional; one of 'halfeye', 'eye', 'gradient' or 'none'
to determine how expected error distribution will be displayed for each
estimated parameter.  Defaults to 'halfeye'.  Currently does not apply
if 'median' is selected as effect size, in which case a simple error bar
will be used}

\item{error_scale}{Optional numeric determining width of the expected error
distribution.  Defaults to 0.3}

\item{error_nudge}{Optional numeric determining degree to which measures
of central tendency will be shifted to the right of the raw data; defaults
to 0.4}

\item{error_normalize}{Optional; one of 'groups', 'all', or 'panels' to
determine how width of the expected error distributions will be normalized.
Defaults to 'groups'.  See documentation in ggdist}

\item{difference_axis_units}{Optional; one of 'raw' or 'sd' to determine
if markings on the difference axis will be in raw-score units or in
standard-deviation units.  For 'sd' the standard deviation of the mean
difference is used, and this is true even if 'median' is selected as the
effect size}

\item{difference_axis_breaks}{Optional numeric > 1 of suggested number of breaks
for the difference axis.  Defaults to 5}

\item{difference_axis_space}{Optional numeric > 0 to indicate spacing to the
difference axis.  Defaults to 1}

\item{simple_contrast_labels}{Optional logical to determine if contrasts are
given simple labels ('Reference', 'Comparison', 'Difference') or more
descriptive labels based on the contrast specified.}

\item{ylim}{Optional 2-item vector specifying y-axis limits.  Defaults to
c(NA NA); Use NA to specify auto-limit.}

\item{ybreaks}{Optional numeric > 2 for suggested number of y-axis breaks;
defaults to 5}

\item{rope}{Optional 2-item vector with item 2 >= item 1.  Use to specify a range
of values to use to visualize a hypothesis test.  If both values are the
same, a point-null hypothesis test will be visualized.  If item2 > item1
an interval-null hypothesis test will be visualized.  Defaults to c(NA, NA),
which is to not visualize a hypothesis test}

\item{rope_units}{Optional; one of 'raw' or 'sd' to indicate units of the rope
passed. Defaults to 'raw'}

\item{ggtheme}{Optional ggplot2 theme object to specify the visual style of the
plot.  Defaults to \code{\link[ggplot2:ggtheme]{ggplot2::theme_classic()}}}
}
\value{
Returns a ggplot object
}
\description{
\code{plot_mdiff} helps visualize comparisons of a continuous outcome
variable between conditions.  It can plot raw data (if available) for each
condition, the mean or median (raw data only) for each condition, and
it emphasizes a 1-df comparison among conditions, plotting the estimated
difference and its confidence interval with a difference axis.
You can pass esci-estimate objects generated
by \code{\link[=estimate_mdiff_one]{estimate_mdiff_one()}}, \code{\link[=estimate_mdiff_two]{estimate_mdiff_two()}},
\code{\link[=estimate_mdiff_paired]{estimate_mdiff_paired()}}, \code{\link[=estimate_mdiff_ind_contrast]{estimate_mdiff_ind_contrast()}},
\code{\link[=estimate_mdiff_2x2_between]{estimate_mdiff_2x2_between()}}, and \code{\link[=estimate_mdiff_2x2_mixed]{estimate_mdiff_2x2_mixed()}}.
This function returns a ggplot2 object.
}
\details{
This function was developed primarily for student use within jamovi when
learning along with the text book Introduction to the New Statistics, 2nd
edition (Cumming & Calin-Jageman, 2024).

Expect breaking changes as this function is improved for general use.  Work
still do be done includes:
\itemize{
\item Revise to avoid deprecated ggplot features
\item Revise for consistent ability to control aesthetics and consistent
layer names
}
}
\examples{
# From raw data
data("data_penlaptop1")

estimate_from_raw <- esci::estimate_mdiff_two(
  data = data_penlaptop1,
  outcome_variable = transcription,
  grouping_variable = condition,
  switch_comparison_order = TRUE,
  assume_equal_variance = TRUE
)

# To visualize the estimated median difference (raw data only)
myplot_from_raw <- esci::plot_mdiff(
  estimate_from_raw,
  effect_size = "median"
)

# To conduct a hypothesis test
res_htest_from_raw <- esci::test_mdiff(
  estimate_from_raw,
  effect_size = "median",
  rope = c(-2, 2)
)


# From summary data
estimate_from_summary <- esci::estimate_mdiff_two(
  comparison_mean = 12.09,
  comparison_sd = 5.52,
  comparison_n = 103,
  reference_mean = 6.88,
  reference_sd = 4.22,
  reference_n = 48,
  grouping_variable_levels = c("Ref-Laptop", "Comp-Pen"),
  outcome_variable_name = "\% Transcription",
  grouping_variable_name = "Note-taking type",
  assume_equal_variance = TRUE
)

# To visualize the estimated mean difference
myplot <- esci::plot_mdiff(
  estimate_from_summary,
  effect_size = "mean"
)

# To conduct a hypothesis test
res_htest_from_summary <- esci::test_mdiff(
  estimate_from_summary,
  effect_size = "mean",
  rope = c(-2, 2)
)

}
