% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_psdsummary.R
\name{aux_psdsummary}
\alias{aux_psdsummary}
\title{Calculate aggregated PSDs over long time periods}
\usage{
aux_psdsummary(
  start,
  stop,
  ID,
  component = "BHZ",
  dir,
  window,
  sensor,
  logger,
  gain = 1,
  hours_skip,
  res = 1000,
  n = 100,
  cpu,
  verbose = FALSE
)
}
\arguments{
\item{start}{\code{POSIXct} value, start time for PSD 
calculation. If a character string (or vector) is provided, the function 
will try to convert it to POSIXct.}

\item{stop}{\code{POSIXct} value, stop time for PSD calculation. 
If a character string (or vector) is provided, the function will try to 
convert it to POSIXct.}

\item{ID}{\code{Character} vector, station ID to be processed}

\item{component}{\code{Character} value or vector, seismic component to 
be used. If omitted, the function will use \code{"BHZ"} by default.}

\item{dir}{\code{Character} value, path to directory that contains the 
seismic files. See \code{read_data} for details and constraints on the 
data structure.}

\item{window}{\code{Numeric} value, time window size for the PSD 
calculation. Should be appropriately large to avoid extensive calculation
times, usually at the order of 0.1 percent of the total PSD duration.}

\item{sensor}{\code{Character} value, sensor keyword for the deconvolution 
step (see \code{signal_deconvolve} for details and keywords). If omitted, 
no deconvolution will be attempted.}

\item{logger}{\code{Character} value, logger keyword for the deconvolution 
step (see \code{signal_deconvolve} for details and keywords). If omitted, 
no deconvolution will be attempted.}

\item{gain}{\code{Numeric} value, signal preamplification factor used for 
the deconvolution step (see \code{signal_deconvolve} for details. Default
value is \code{1}.}

\item{hours_skip}{\code{Integer} vector, one or more full hours that will
be excluded from the PSD generation. This optional value is useful if one 
wants to omit noisy daytime hours.}

\item{res}{\code{Numeric} value, frequency resolution of the PSD, by 
default set to \code{1000}. This is used to reduce the resulting data 
size.}

\item{n}{\code{Numeric} value, number of times to try to find a time 
snippet with data to estimate the frequency vector length. By
default set to \code{100}.}

\item{cpu}{\code{Numeric} value, fraction of CPUs to use. If omitted, 
only one CPU will be used.}

\item{verbose}{\code{Logical} value, option to show extended function 
information as the function is running. Default is \code{FALSE}.}
}
\value{
\code{eseis} object, a spectrogram
}
\description{
The function generates a long time PSD with aggregated time and frequency
resolution.
}
\details{
The function will calculate PSDs using the Welch method (see 
\code{signal_spectrogram}), with no overlap of the main time windows. The 
sub-windows will be automatically set to 10 % of the main window size and 
the overlap of sub-windows to 0.5.
}
\examples{

\dontrun{

p <- aux_psdsummary(start = "2017-04-15 19:00:00 UTC",
                    stop = "2017-04-15 22:00:00 UTC",
                    ID = "RUEG1",
                    component = "BHE",
                    dir = "~/data/sac/",
                    sensor = "TC120s", 
                    logger = "Cube3ext",
                    window = 600,
                    res = 1000,
                    verbose = TRUE)
                    
plot(p)

}

}
\author{
Michael Dietze
}
\keyword{eseis}
