% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_filters.R
\name{farima_to_ar}
\alias{farima_to_ar}
\title{AR Representation of a FARIMA Model}
\usage{
farima_to_ar(ar = numeric(0), ma = numeric(0), d = 0, max_i = 1000)
}
\arguments{
\item{ar}{the AR-coefficient series ordered by lag.}

\item{ma}{the MA-coefficient series ordered by lag.}

\item{d}{the fractional differencing coefficient.}

\item{max_i}{the maximum index up until which to return the coefficient series.}
}
\value{
A numeric vector is returned.
}
\description{
Output has representation with positive signs (on the right-hand side of the equation); inputs are both with positive signs (on right-hand side of equation).
}
\details{
Consider the FARIMA model
\deqn{(1-B)^d Y_t = ar_1 X_{t-1} + ... + ar_p X_{t-p}+ma_1 e_{t-1}+...+ma_q e_{t-q}+e_t,}
where \eqn{e_t} are the innovations and where \eqn{X_t=(1-B)^d Y_t}.
\eqn{ar_i}, \eqn{i=1, ..., p}, are the AR-coefficients to pass to the
argument \code{ar}, \eqn{ma_j}, \eqn{j = 1, ..., q}, are the MA-coefficients
to pass to the argument \code{ma}. \eqn{d} is the fractional differencing
coefficient. The function then returns the coefficients
from the corresponding infinite-order AR-representation
\deqn{-e_t = c_0 Y_t + c_1 Y_{t-1}+c_2 Y_{t-2} + c_3 Y_{t-3} + ...,}
where \eqn{c_l}, \eqn{l = 0, 1, 2, ...}, are the coefficients. Following this
notation, \eqn{c_0 = -1} by definition.
}
\examples{
farima_to_ar(ar = 0.75, ma = 0.5, d = 0.3, max_i = 100)

}
\author{
\itemize{
\item Dominik Schulz (Scientific Employee) (Department of Economics,
Paderborn University), \cr
Author
}
}
