% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{rho_priors}
\alias{rho_priors}
\title{Specify prior for the spatial autoregressive parameter and sampling settings}
\usage{
rho_priors(
  rho_a_prior = 1,
  rho_b_prior = 1,
  rho_min = 0,
  rho_max = 1,
  init_rho_scale = 1,
  griddy_n = 60,
  use_griddy_gibbs = TRUE,
  mh_tune_low = 0.4,
  mh_tune_high = 0.6,
  mh_tune_scale = 0.1
)
}
\arguments{
\item{rho_a_prior}{Single number. Prior hyperparameter for the four-parameter beta distribution \code{\link{betapdf}}.
Defaults to 1.}

\item{rho_b_prior}{Single number. Prior hyperparameter for the four-parameter beta distribution \code{\link{betapdf}}.
Defaults to 1.}

\item{rho_min}{Minimum value for \eqn{\rho} (default: 0)}

\item{rho_max}{Maximum value for \eqn{\rho} (default: 1)}

\item{init_rho_scale}{For Metropolis-Hastings step the initial candidate variance (default: 1)}

\item{griddy_n}{single integer number. Sets how fine the grid approximation is. Default
value is 60.}

\item{use_griddy_gibbs}{Binary value. Should griddy-Gibbs be used for \eqn{\rho} estimation?
\code{use_griddy_gibbs=TRUE} does not work if \code{row_standardized_prior = FALSE} is specified in the \eqn{W} prior specification.
if TRUE: griddy-Gibbs step for sampling \eqn{\rho}; if FALSE: tuned random-walk Metropolis-Hastings step}

\item{mh_tune_low}{Lower bound of acceptance rate for Metropolis-Hastings tuning
(used if \code{use_griddy_gibbs==FALSE})}

\item{mh_tune_high}{Upper bound of acceptance rate for Metropolis-Hastings tuning
(used if \code{use_griddy_gibbs==FALSE})}

\item{mh_tune_scale}{Scaling factor for Metropolis-Hastings tuning
(used if \code{use_griddy_gibbs==FALSE})}
}
\description{
Specify prior for the spatial autoregressive parameter and sampling settings
}
