% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbRunScript.R
\name{dbRunScript}
\alias{dbRunScript}
\title{Execute an SQL script}
\usage{
dbRunScript(conn, script, echo = FALSE, ...)
}
\arguments{
\item{conn}{a \code{\link[DBI]{DBIConnection-class}} object}

\item{script}{Either a filename pointing to an SQL script or
a character vector of length 1 containing SQL.}

\item{echo}{print the SQL commands to the output?}

\item{...}{arguments passed to \code{\link[DBI]{dbExecute}}}
}
\value{
a list of results from \code{dbExecute} for each of the individual
SQL statements in \code{script}.
}
\description{
Execute an SQL script
}
\details{
The SQL script file must be \code{;} delimited.
}
\examples{
sql <- "SHOW TABLES; SELECT 1+1 as Two;"
sql2 <- system.file("sql", "mtcars.mysql", package = "etl")
sql3 <- "SELECT * FROM user WHERE user = 'mysql';SELECT * FROM user WHERE 't' = 't';"

if (require(RSQLite)) {
  con <- dbConnect(RSQLite::SQLite())
  dbRunScript(con, "SELECT 1+1 as Two; VACUUM; ANALYZE;")
}
\dontrun{
if (require(RMySQL)) {
 con <- dbConnect(RMySQL::MySQL(), default.file = path.expand("~/.my.cnf"),
   group = "client",user = NULL, password = NULL, dbname = "mysql", host = "127.0.0.1")
 dbRunScript(con, script = sql)
 dbRunScript(con, script = sql2)
 dbRunScript(con, script = sql3)
 dbDisconnect(con)
}
}

}
