% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dot_plot.R
\name{dot_plot}
\alias{dot_plot}
\title{creates a dot-plot of safety data showing the absolute and relative risks}
\usage{
dot_plot(
  safety,
  type = c("non_serious", "serious"),
  reference = safety$GROUP$title[1],
  size = 95,
  text_width = 10,
  base = 2,
  valid_estimates = TRUE
)
}
\arguments{
\item{safety}{an object created by \code{\link{safety_summary}} or by \code{\link{relative_risk}}, in case you want to re-order or filter the choice of rows.}

\item{type}{a choice of "non_serious" (default) or "serious" as to which type of AE to report on}

\item{reference}{character vector naming the reference arm for the calculations. 
Defaults to the first row of the safety$GROUP.}

\item{size}{a number between 0-100, giving the size of the confidence interval. 
Default is 95.}

\item{text_width}{Integer giving a target width to which the labels are wrapped. Defaults to 10.}

\item{base}{numeric value to which a log scale uses as tick marks. Suggest powers of 2, or 5.}

\item{valid_estimates}{a logical, which determines if only terms with valid estimates of relative risk are included in the table.
The alternative is to include terms with zeroes.}
}
\value{
a graphical object that shows the estimates and CI of relative and absolute risk.
}
\description{
creates a dot-plot of safety data showing the absolute and relative risks
}
\details{
This is essentially a list of two ggplot objects joined together in a list, named
as "left.panel" and "right.panel". 
They can each be individually edited if needed
}
\examples{
safety_statistics <- safety_summary(safety,
           exposed=c("Experimental"=60,"Control"=67))
head( relative_risk(safety_statistics, type="serious") )
fig <- dot_plot(safety_statistics, type="non_serious", base=4)
fig
fig$left.panel <- fig$left.panel + ggplot2::labs(title="Absolute Risk")
fig
temp <- tempfile(fileext=".png")
png(filename = temp)
print(fig)
dev.off()

}
\seealso{
\code{\link{safety_summary}} \code{\link{relative_risk}} [relative_risks()]
}
