% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_inventory.R
\name{get_inventory}
\alias{get_inventory}
\title{Get inventory from path containing EURO-CORDEX .nc files}
\usage{
get_inventory(path, add_files = TRUE)
}
\arguments{
\item{path}{Path that will be searched recursively for .nc files.}

\item{add_files}{Boolean (default \code{TRUE}), if \code{TRUE}, will add a
column containing lists of associated files with their full paths (useful
e.g. for further processing).}
}
\value{
A data.table with the inventory information.
}
\description{
Returns a data.table with information by splitting the netcdf files into
their components (GCM, RCM, variable, experiment, ...) and aggregates over
years.
}
\examples{
\dontrun{

path <- "/mnt/CEPH_BASEDATA/METEO/SCENARIO"
dat <- get_inventory(path)
print(dat)

}
}
\seealso{
\code{\link{compare_variables_in_inventory}} for further comparing
  the results, and \code{\link{check_inventory}} for performing some checks.
}
