% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epmc_tm.r
\name{epmc_tm}
\alias{epmc_tm}
\title{Get text-mined terms}
\usage{
epmc_tm(ext_id = NULL, data_src = "med", semantic_type = NULL,
  limit = 100, verbose = TRUE)
}
\arguments{
\item{ext_id}{character, publication identifier}

\item{data_src}{character, data source, by default Pubmed/MedLine index will be searched.
The only sources relevant to this methods are \code{med} and \code{pmc}.
\describe{
\item{med}{Publications from PubMed and MEDLINE}
\item{pmc}{Publications from PubMed Central}}}

\item{semantic_type}{controlled vocabulary. Specify the semantic type you
wish to retrieve. The following types are supported:
  \describe{
  \item{ACCESSION}{accession IDs for DNA or protein sequences}
  \item{CHEMICAL}{chemicals}
  \item{DISEASE}{diseases}
  \item{EFO}{Experimental Factor Ontology
    (\url{http://www.ebi.ac.uk/efo/})}
  \item{GENE_PROTEIN}{gene proteins}
  \item{GO_TERM}{Gene Ontology Terms (\url{http://geneontology.org/})}
  \item{ORGANISM}{organism}
  }}

\item{limit}{Number of records to be returned. By default, this function
returns 100 records.}

\item{verbose}{print information about what's going on}
}
\value{
Terms found as tibble
}
\description{
Retrieve a count and a list of text-mined terms gathered by Europe PMC.
}
\examples{
\dontrun{
epmc_tm("25249410")
epmc_tm("25249410", semantic_type = "GO_TERM")
epmc_tm("PMC4340542", data_src = "pmc", semantic_type = "GO_TERM")
}
}
