% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cate.R
\name{cate}
\alias{cate}
\title{Calculate categorical statistics in related to a threshold}
\usage{
cate(
  model,
  observation,
  threshold,
  cutoff = NA,
  nobs = 8,
  rname,
  to.plot = F,
  col = "#4444bb",
  pch = 19,
  lty = 3,
  lcol = "#333333",
  lim,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{model}{numeric vector with paired model data}

\item{observation}{numeric vector with paired observation data}

\item{threshold}{reference value}

\item{cutoff}{(optionally the maximum) valid value for observation}

\item{nobs}{minimum number of observations}

\item{rname}{row name}

\item{to.plot}{TRUE to plot a scatter-plot}

\item{col}{color for points}

\item{pch}{pch of points}

\item{lty}{lty of threshold lines}

\item{lcol}{col of threshold lines}

\item{lim}{limit for x and y}

\item{verbose}{display additional information}

\item{...}{arguments passed to plot}
}
\value{
a data.frame including: Accuracy (A); Critical Success Index (CSI); Probability of Detection (POD); Bias(B); False Alarm Ratio (FAR); Heidke Skill Score (HSS); Pearce skill Score (PSS) in %. The number of valid observations (n), average of observations (Obs) and model (Mod) and the used threshold (thr) are also included for additional information.
}
\description{
Calculate traditional statistics related to a threshold
}
\examples{
data <- 0.02 * 1:100
set.seed(666)
model  <- abs(rnorm(100,0.01))

oldpar <- par(pty="s")
cate(model = model, observation = data, threshold = 1,
     to.plot = TRUE, rname = 'example')
par(oldpar)

}
\references{
Yu, S., Mathur, R., Schere, K., Kang, D., Pleim, J., Young, J., ... & Rao, S. T. (2008).
Evaluation of real‐time PM2. 5 forecasts and process analysis for PM2. 5 formation over
the eastern United States using the Eta‐CMAQ forecast model during the 2004 ICARTT study.
Journal of Geophysical Research: Atmospheres, 113(D6).
}
