% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mda8.R
\name{mda8}
\alias{mda8}
\title{Maximum Daily 8-hr Average}
\usage{
mda8(data, time = "date", var, verbose = TRUE)
}
\arguments{
\item{data}{data.frame with time column and variable columns to be processed}

\item{time}{name of the time column (default is date) in POSIXct}

\item{var}{name of the columns to be calculated}

\item{verbose}{display additional information}
}
\value{
data.frame with time and the maximum daily 8-hr average
}
\description{
function to calculate Ozone Maximum Daily 8-hr Average or 8-hr moving Average for a data.frame
}
\examples{
model_file <- paste(system.file("extdata", package = "eva3dm"),
                    "/model_o3_ugm3_36km.Rds", sep="")
model      <- readRDS(model_file)
model_mda8 <- mda8(model)
model_8h   <- ma8h(model)
plot(model$date,model$Campinas, pch = 19,
     main = expression(O[3]~~'['*mu*g*m^-3*']'))
points(model_8h$date,model_8h$Campinas, col = 'blue', pch = 19)
points(model_mda8$date + 17*60*60,model_mda8$Campinas,
       col = 'red', pch = 4, cex = 2)
legend('topleft',bty = 'n',
       pch = c(19,19,4),
       legend = c('hourly','8h-mov average','MD8A'),
       col = c('black','blue','red'))
}
