% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_evzinb.R
\name{summary.evzinb}
\alias{summary.evzinb}
\title{EVZINB summary function}
\usage{
\method{summary}{evzinb}(
  object,
  coef = c("original", "bootstrapped_mean", "bootstrapped_median"),
  standard_error = TRUE,
  p_value = c("bootstrapped", "approx", "both", "none"),
  bootstrapped_props = c("none", "mean", "median"),
  approx_t_value = TRUE,
  symmetric_bootstrap_p = TRUE,
  ...
)
}
\arguments{
\item{object}{an EVZINB object with bootstraps}

\item{coef}{Type of coefficients. Original are the coefficient estimates from the non-bootstrapped version of the model. 'bootstrapped_mean' are the mean coefficients across bootstraps, and 'bootstrapped_median' are the median coefficients across bootstraps}

\item{standard_error}{Should standard errors be computed?}

\item{p_value}{What type of p_values should be computed? 'bootstrapped' are bootstrapped p_values through confidence interval inversion. 'approx' are p-values based on the t-value produced by dividing the coefficient with the standard error.}

\item{bootstrapped_props}{Type of bootstrapped proportions of component proportions to be returned}

\item{approx_t_value}{Should approximate t-values be returned}

\item{symmetric_bootstrap_p}{Should bootstrap p-values be computed as symmetric (leaving alpha/2 percent in each tail)? FALSE gives non-symmetric, but narrower, intervals. TRUE corresponds most closely to conventional p-values.}

\item{...}{Additional arguments passed to the summary function}
}
\value{
An EVZINB summary object
}
\description{
EVZINB summary function
}
\examples{
data(genevzinb2)
model <- evzinb(y~x1+x2+x3,data=genevzinb2, n_bootstraps = 10, multicore = TRUE, ncores = 2)
summary(model)

}
